/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.compile;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.python.core.PyException;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.modules._py_compile;
import org.slf4j.Logger;

public class PythonCompiler {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PythonCompiler.class);

    public void log(String message) {
        LOGGER.info(message);
    }

    public void process(Set<File> toCompile, File destDir) throws ToolException {
        if (toCompile.isEmpty()) {
            return;
        }
        this.log("Compiling " + toCompile.size() + " files");
        Properties props = new Properties();
        props.setProperty("python.cachedir.skip", "true");
        PySystemState.initialize((Properties)System.getProperties(), (Properties)props);
        for (File src : toCompile) {
            String name = _py_compile.getModuleName((File)src);
            String compiledFilePath = name.replace('.', File.separatorChar);
            if (src.getName().endsWith("__init__.py")) {
                compiledFilePath = compiledFilePath + File.separator + "__init__";
            }
            File compiled = new File(destDir, compiledFilePath + "$py.class");
            this.compile(src, compiled, name);
            this.log(name + " => " + compiled);
        }
    }

    protected void compile(File src, File compiled, String moduleName) throws ToolException {
        byte[] bytes;
        try {
            bytes = imp.compileSource((String)moduleName, (File)src);
        }
        catch (PyException pye) {
            LOGGER.error(pye.getMessage());
            throw new ToolException("Compile failed; see the compiler error output for details.", false, (Throwable)pye);
        }
        File dir = compiled.getParentFile();
        if (!dir.exists() && !compiled.getParentFile().mkdirs()) {
            throw new ToolException("Unable to make directory for compiled file: " + compiled);
        }
        try {
            imp.cacheCompiledSource((String)src.getCanonicalPath(), (String)compiled.getCanonicalPath(), (byte[])bytes);
        }
        catch (IOException e) {
            LOGGER.error("Unable to get py file");
            throw new ToolException("Unable to get py file: ");
        }
    }
}

