/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.psdk.parser;

import com.huawei.ism.tool.framework.platform.util.XmlEnums;
import com.huawei.ism.tool.pyengine.psdk.bean.FiledMapping;
import com.huawei.ism.tool.pyengine.psdk.bean.SceneConfigItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneFiledMappingParser {
    private static final Logger log = LoggerFactory.getLogger(SceneFiledMappingParser.class);

    public static Map<FiledMapping, List<FiledMapping>> parser(String file) {
        HashMap<FiledMapping, List<FiledMapping>> allSceneFiledMappings = new HashMap<FiledMapping, List<FiledMapping>>();
        try (InputStream inStream = SceneFiledMappingParser.class.getResourceAsStream(file);){
            Document document = SceneFiledMappingParser.parseXMLDoc(inStream);
            Element root = document.getRootElement();
            for (Element sceneEle : SceneFiledMappingParser.getElementsByName(root, "scene")) {
                FiledMapping sceneMapping = SceneFiledMappingParser.parseEle(sceneEle);
                ArrayList<FiledMapping> stepMappings = new ArrayList<FiledMapping>();
                for (Element stepEle : SceneFiledMappingParser.getElementsByName(sceneEle, "step")) {
                    FiledMapping stepMapping = SceneFiledMappingParser.parseEle(stepEle);
                    stepMappings.add(stepMapping);
                }
                allSceneFiledMappings.put(sceneMapping, stepMappings);
            }
        }
        catch (IOException e) {
            log.error("parse file error {}", (Object)file);
        }
        return allSceneFiledMappings;
    }

    private static FiledMapping parseEle(Element ele) {
        String id = ele.attributeValue("id");
        String mappings = ele.attributeValue("mapping");
        FiledMapping filedMapping = new FiledMapping(id);
        List<String> mappingList = Arrays.stream(mappings.split(",")).map(String::trim).collect(Collectors.toList());
        filedMapping.setMappings(mappingList);
        return filedMapping;
    }

    public static Optional<SceneConfigItem> getSceneItem(Map<FiledMapping, List<FiledMapping>> sceneMappings, String sceneId, String stepId) {
        Optional<FiledMapping> matchScene = sceneMappings.keySet().stream().filter(filedMapping -> filedMapping.getMappings().contains(sceneId)).findFirst();
        if (!matchScene.isPresent()) {
            return Optional.empty();
        }
        Optional<FiledMapping> matchStep = sceneMappings.get(matchScene.get()).stream().filter(filedMapping -> filedMapping.getMappings().contains(stepId)).findFirst();
        return matchStep.map(filedMapping -> new SceneConfigItem(((FiledMapping)matchScene.get()).getId(), filedMapping.getId()));
    }

    private static Document parseXMLDoc(InputStream in) {
        Document doc;
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setFeature(XmlEnums.DISALLOW_DOCTYPE_DECL.getResourceValue(), true);
            saxReader.setFeature(XmlEnums.SECURE_PROCESSING.getResourceValue(), true);
            saxReader.setFeature(XmlEnums.EXTERNAL_GENERAL_ENTITY.getResourceValue(), false);
            saxReader.setFeature(XmlEnums.EXTERNAL_PARAMETER_ENTITY.getResourceValue(), false);
            saxReader.setFeature(XmlEnums.LOAD_EXTERNAL_DTD.getResourceValue(), false);
            doc = saxReader.read(in);
        }
        catch (Exception e) {
            log.error("Read task queue file failed...", (Throwable)e);
            doc = DocumentHelper.createDocument();
        }
        return doc;
    }

    private static List<Element> getElementsByName(Element parent, String name) {
        ArrayList<Element> els = new ArrayList<Element>();
        Iterator it = parent.elementIterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!name.equals(e.getName())) continue;
            els.add(e);
        }
        return els;
    }
}

