/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.utils;

import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public final class ErrorCodeUtils {
    private static final Logger LOGGERPY = ToolLoggerFactory.getLoggerInStandAlone("PY_LOGGER");
    private static final String SCFILENAME = "getTlvErrDesc.py";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ErrorCodeUtils.class);

    private ErrorCodeUtils() {
    }

    public static synchronized String queryErrorMessage(JythonExecuter jythonExecuter, long errorId) {
        String msg = "" + errorId;
        List<File> classPaths = jythonExecuter.getClassPaths();
        if (classPaths == null || classPaths.isEmpty()) {
            LOGGERPY.error("not found script file from");
            return msg;
        }
        HashMap<String, Object> param = null;
        File scFile = null;
        try {
            scFile = ErrorCodeUtils.queryScFile(classPaths);
            if (null == scFile) {
                LOGGERPY.error("query script file error");
                throw new NullPointerException();
            }
            if (!scFile.exists()) {
                LOGGERPY.error("not found script file from" + classPaths.toString());
                return msg;
            }
            jythonExecuter.compileScript(scFile);
            param = new HashMap<String, Object>();
            String lang = "en".equals(LanguageManager.getInstance().getCurrentLanguage().getLanguage()) ? "en" : "zh";
            param.put("lang", lang);
            param.put("errorId", errorId);
            Object ret = jythonExecuter.simpleInvokeFunction("execute", param);
            LOGGERPY.error(ret.toString());
            msg = ret.toString();
        }
        catch (RuntimeException e) {
            LOGGER.error("execute py script runtime exception.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("execute py script :" + scFile + " error", (Throwable)e);
        }
        return msg;
    }

    private static File queryScFile(List<File> classPaths) {
        for (File parentFile : classPaths) {
            File fileTemp = new File(parentFile, SCFILENAME);
            if (!fileTemp.exists()) continue;
            return fileTemp;
        }
        return null;
    }
}

