/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.service.impl;

import com.huawei.encryptbase.callback.UpdateWkCallback;
import com.huawei.encryptbase.exception.ProcessEncryptException;
import com.huawei.encryptbase.service.IAesEncryptService;
import com.huawei.encryptbase.service.impl.KmcLoggerImpl;
import com.huawei.encryptbase.utils.ConvertUtils;
import com.huawei.encryptbase.utils.CryptParamPropUtils;
import com.huawei.encryptbase.utils.InputParamValidator;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ILogger;
import com.huawei.kmc.common.INotifyCallback;
import com.huawei.kmc.crypt.CryptoAPI;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEncryptImpl
implements IAesEncryptService {
    private static final Logger log = LoggerFactory.getLogger(AesEncryptImpl.class);
    private static final CryptoAPI CRYPTO_API = CryptoAPI.getInstance();

    private static void initBase() {
        CryptoAPI.setJniNotifyCallback((INotifyCallback)new UpdateWkCallback());
        CryptoAPI.setJniLogger((ILogger)new KmcLoggerImpl());
        CryptoAPI.setLogLevel((ILogger.LogLevel)ILogger.LogLevel.INFO);
    }

    private static Properties initConfigParam() {
        Properties appConfig = new Properties();
        appConfig.setProperty("auto_update_mk_enabled", CryptParamPropUtils.getAutoUpdateMkEnabled());
        appConfig.setProperty("crypt_key_lifetime_days", CryptParamPropUtils.getCryptKeyLifetimeDays());
        appConfig.setProperty("primary_key_store_file", CryptParamPropUtils.getPrimaryKeyStoreFile());
        appConfig.setProperty("standby_key_store_file", CryptParamPropUtils.getStandbyKeyStoreFile());
        appConfig.setProperty("domain_count", CryptParamPropUtils.getDomainCount());
        return appConfig;
    }

    private static void initKmc(Properties appConfig) {
        try {
            CRYPTO_API.initialize(appConfig);
        }
        catch (AppException e) {
            log.error("initialize EncryptService error.", (Throwable)e);
        }
    }

    @Override
    public String encrypt(String content) {
        InputParamValidator.checkInputStr(content);
        byte[] contentArr = ConvertUtils.strToByte(content);
        try {
            byte[] cipherByte = CRYPTO_API.encrypt(contentArr);
            Optional<String> cipherStrOptional = ConvertUtils.byteToStr(cipherByte);
            return cipherStrOptional.orElse("");
        }
        catch (Exception e) {
            throw new ProcessEncryptException("encrypt error.", e);
        }
    }

    @Override
    public byte[] encryptByte(byte[] content) {
        return this.encryptByte(content, 0);
    }

    @Override
    public byte[] encryptByte(byte[] originalContent, int domainId) {
        InputParamValidator.checkByteInput(originalContent);
        InputParamValidator.checkInputIntNotLessThanZero(domainId);
        try {
            return CRYPTO_API.encrypt(domainId, originalContent);
        }
        catch (Exception e) {
            throw new ProcessEncryptException("encrypt byte error.", e);
        }
    }

    @Override
    public String decrypt(String content) {
        InputParamValidator.checkInputStr(content);
        byte[] contentByte = ConvertUtils.strToByte(content);
        try {
            byte[] plainTextArr = CRYPTO_API.decrypt(contentByte);
            Optional<String> plainTextStrOptional = ConvertUtils.byteToStr(plainTextArr);
            return plainTextStrOptional.orElse("");
        }
        catch (Exception e) {
            throw new ProcessEncryptException("decrypt error.", e);
        }
    }

    @Override
    public byte[] decryptByte(byte[] content) {
        return this.decryptByte(content, 0);
    }

    @Override
    public byte[] decryptByte(byte[] encryptContent, int domainId) {
        InputParamValidator.checkByteInput(encryptContent);
        try {
            return CRYPTO_API.decrypt(encryptContent);
        }
        catch (Exception e) {
            throw new ProcessEncryptException("decrypt byte error.", e);
        }
    }

    @Override
    public void importWorkKeyByDomainId(int domainId, byte[] content) {
        InputParamValidator.checkInputIntNotLessThanZero(domainId);
        InputParamValidator.checkByteInput(content);
        try {
            CRYPTO_API.registerByteKey(domainId, content);
        }
        catch (Exception e) {
            throw new ProcessEncryptException("importWorkKeyByDomainId error.", e);
        }
    }

    @Override
    public byte[] generateSecurityKey(int length) {
        InputParamValidator.checkInputIntNotLessThanZero(length);
        try {
            return CRYPTO_API.genSecByteKey(length);
        }
        catch (Exception e) {
            throw new ProcessEncryptException("genSecByteKey error.", e);
        }
    }

    static {
        AesEncryptImpl.initBase();
        Properties appConfig = AesEncryptImpl.initConfigParam();
        AesEncryptImpl.initKmc(appConfig);
    }
}

