/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.utils;

import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Optional;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;

public class ConvertUtils {
    public static final int HEX = 255;
    private static final int HEX_MAX = 16;
    private static final int NUM_TWO = 2;
    private static final int INT0XFF = 255;
    private static final String KEY_ALGORITHM = "AES";

    public static byte[] strToByte(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return new byte[0];
        }
        return str.getBytes(StandardCharsets.UTF_8);
    }

    public static Optional<String> byteToStr(byte[] byteArray) {
        if (byteArray == null) {
            return Optional.empty();
        }
        return Optional.of(new String(byteArray, StandardCharsets.UTF_8));
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (byte bb : buf) {
            String hex = Integer.toHexString(bb & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase(Locale.US));
        }
        return sb.toString();
    }

    public static byte[] asBin(String inStr) {
        if (inStr.length() < 1) {
            return new byte[0];
        }
        byte[] encrypted = new byte[inStr.length() / 2];
        for (int ins = 0; ins < inStr.length() / 2; ++ins) {
            int high = Integer.parseInt(inStr.substring(ins * 2, ins * 2 + 1), 16);
            int low = Integer.parseInt(inStr.substring(ins * 2 + 1, ins * 2 + 2), 16);
            encrypted[ins] = (byte)(high * 16 + low);
        }
        return encrypted;
    }

    public static String asHex(byte[] inBuf) {
        StringBuilder strbuf = new StringBuilder(inBuf.length * 2);
        String str = "0";
        for (byte bs : inBuf) {
            if ((bs & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(bs & 0xFF, 16));
        }
        return strbuf.toString();
    }

    public static SecretKeySpec convertToSecretKey(byte[] key) {
        return new SecretKeySpec(key, KEY_ALGORITHM);
    }
}

