/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.utils;

import com.huawei.encryptbase.exception.InputParamException;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class InputParamValidator {
    private InputParamValidator() {
    }

    public static void checkInputPublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            throw new InputParamException("Input publicKey is null.");
        }
    }

    public static void checkInputPrivateKey(PrivateKey privateKey) {
        if (privateKey == null) {
            throw new InputParamException("Input privateKey is null.");
        }
    }

    public static void checkByteInput(byte[] inputByte) {
        if (inputByte == null || inputByte.length == 0) {
            throw new InputParamException("Input byte is null or empty.");
        }
    }

    public static void checkInputStr(String inputStr) {
        if (StringUtils.isBlank((CharSequence)inputStr)) {
            throw new InputParamException("Input string is blank.");
        }
    }

    public static void checkInputIntNotLessThanZero(int inputInt) {
        if (inputInt < 0) {
            throw new InputParamException("Input int can not be less than 0.");
        }
    }

    public static void checkInputObjectIsByteOrFile(Object object) {
        if (Objects.isNull(object)) {
            throw new InputParamException("objects can not be null.");
        }
        if (object instanceof byte[]) {
            return;
        }
        if (object instanceof File) {
            if (!((File)object).exists()) {
                throw new InputParamException("the file is not exists.");
            }
            return;
        }
        throw new InputParamException("object is neither byte[] nor file.");
    }
}

