/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.utils;

import com.huawei.encryptbase.exception.EncryptBaseException;
import com.huawei.encryptbase.utils.WaitUtil;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.crypt.CryptoAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateAesEncryptKeyUtils {
    private static final Logger log = LoggerFactory.getLogger(UpdateAesEncryptKeyUtils.class);
    private static final int ROOT_WORK_KEY_UPDATE_INTERVAL_MILLS = 100;

    public static void updateRootKeyImmediate() throws EncryptBaseException {
        log.info("start update root key.");
        try {
            CryptoAPI.getInstance().updateRootKey();
        }
        catch (AppException e) {
            log.error("update root key fail.");
            throw new EncryptBaseException("update root key fail", e);
        }
        log.info("update root key success.");
    }

    public static void updateWorkKeyImmediate() throws EncryptBaseException {
        log.info("start update work key.");
        try {
            CryptoAPI.getInstance().activeNewKey();
        }
        catch (AppException e) {
            log.error("update work key fail.");
            throw new EncryptBaseException("update work key fail", e);
        }
        log.info("update work key success.");
    }

    public static void updateAllKeyImmediate() throws EncryptBaseException {
        UpdateAesEncryptKeyUtils.updateRootKeyImmediate();
        WaitUtil.waitMills(100L);
        UpdateAesEncryptKeyUtils.updateWorkKeyImmediate();
    }
}

