/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.api.DiscardPolicy;
import io.nats.client.api.Mirror;
import io.nats.client.api.Placement;
import io.nats.client.api.RetentionPolicy;
import io.nats.client.api.Source;
import io.nats.client.api.StorageType;
import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;

public class StreamConfiguration
implements JsonSerializable {
    private final String name;
    private final String description;
    private final List<String> subjects;
    private final RetentionPolicy retentionPolicy;
    private final long maxConsumers;
    private final long maxMsgs;
    private final long maxMsgsPerSubject;
    private final long maxBytes;
    private final Duration maxAge;
    private final long maxMsgSize;
    private final StorageType storageType;
    private final int replicas;
    private final boolean noAck;
    private final String templateOwner;
    private final DiscardPolicy discardPolicy;
    private final Duration duplicateWindow;
    private final Placement placement;
    private final Mirror mirror;
    private final List<Source> sources;
    private final boolean sealed;
    private final boolean allowRollup;
    private final boolean denyDelete;
    private final boolean denyPurge;

    static StreamConfiguration instance(String json) {
        Builder builder = new Builder();
        Matcher m = ApiConstants.RETENTION_RE.matcher(json);
        if (m.find()) {
            builder.retentionPolicy(RetentionPolicy.get(m.group(1)));
        }
        if ((m = ApiConstants.STORAGE_TYPE_RE.matcher(json)).find()) {
            builder.storageType(StorageType.get(m.group(1)));
        }
        if ((m = ApiConstants.DISCARD_RE.matcher(json)).find()) {
            builder.discardPolicy(DiscardPolicy.get(m.group(1)));
        }
        builder.name(JsonUtils.readString(json, ApiConstants.NAME_RE));
        builder.description(JsonUtils.readString(json, ApiConstants.DESCRIPTION_RE));
        JsonUtils.readLong(json, ApiConstants.MAX_CONSUMERS_RE, builder::maxConsumers);
        JsonUtils.readLong(json, ApiConstants.MAX_MSGS_RE, builder::maxMessages);
        JsonUtils.readLong(json, ApiConstants.MAX_MSGS_PER_SUB_RE, builder::maxMessagesPerSubject);
        JsonUtils.readLong(json, ApiConstants.MAX_BYTES_RE, builder::maxBytes);
        JsonUtils.readNanos(json, ApiConstants.MAX_AGE_RE, builder::maxAge);
        JsonUtils.readLong(json, ApiConstants.MAX_MSG_SIZE_RE, builder::maxMsgSize);
        JsonUtils.readInt(json, ApiConstants.NUM_REPLICAS_RE, builder::replicas);
        builder.noAck(JsonUtils.readBoolean(json, ApiConstants.NO_ACK_RE));
        builder.templateOwner(JsonUtils.readString(json, ApiConstants.TEMPLATE_OWNER_RE));
        JsonUtils.readNanos(json, ApiConstants.DUPLICATE_WINDOW_RE, builder::duplicateWindow);
        builder.subjects(JsonUtils.getStringList("subjects", json));
        builder.placement(Placement.optionalInstance(json));
        builder.mirror(Mirror.optionalInstance(json));
        builder.sources(Source.optionalListOf(json));
        builder.sealed(JsonUtils.readBoolean(json, ApiConstants.SEALED_RE));
        builder.allowRollup(JsonUtils.readBoolean(json, ApiConstants.ALLOW_ROLLUP_HDRS_RE));
        builder.denyDelete(JsonUtils.readBoolean(json, ApiConstants.DENY_DELETE_RE));
        builder.denyPurge(JsonUtils.readBoolean(json, ApiConstants.DENY_PURGE_RE));
        return builder.build();
    }

    StreamConfiguration(Builder b) {
        this.name = b.name;
        this.description = b.description;
        this.subjects = b.subjects;
        this.retentionPolicy = b.retentionPolicy;
        this.maxConsumers = b.maxConsumers;
        this.maxMsgs = b.maxMsgs;
        this.maxMsgsPerSubject = b.maxMsgsPerSubject;
        this.maxBytes = b.maxBytes;
        this.maxAge = b.maxAge;
        this.maxMsgSize = b.maxMsgSize;
        this.storageType = b.storageType;
        this.replicas = b.replicas;
        this.noAck = b.noAck;
        this.templateOwner = b.templateOwner;
        this.discardPolicy = b.discardPolicy;
        this.duplicateWindow = b.duplicateWindow;
        this.placement = b.placement;
        this.mirror = b.mirror;
        this.sources = b.sources;
        this.sealed = b.sealed;
        this.allowRollup = b.allowRollup;
        this.denyDelete = b.denyDelete;
        this.denyPurge = b.denyPurge;
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "name", this.name);
        JsonUtils.addField(sb, "description", this.description);
        JsonUtils.addStrings(sb, "subjects", this.subjects);
        JsonUtils.addField(sb, "retention", this.retentionPolicy.toString());
        JsonUtils.addField(sb, "max_consumers", this.maxConsumers);
        JsonUtils.addField(sb, "max_msgs", this.maxMsgs);
        JsonUtils.addField(sb, "max_msgs_per_subject", this.maxMsgsPerSubject);
        JsonUtils.addField(sb, "max_bytes", this.maxBytes);
        JsonUtils.addFieldAsNanos(sb, "max_age", this.maxAge);
        JsonUtils.addField(sb, "max_msg_size", this.maxMsgSize);
        JsonUtils.addField(sb, "storage", this.storageType.toString());
        JsonUtils.addField(sb, "num_replicas", this.replicas);
        JsonUtils.addFldWhenTrue(sb, "no_ack", this.noAck);
        JsonUtils.addField(sb, "template_owner", this.templateOwner);
        JsonUtils.addField(sb, "discard", this.discardPolicy.toString());
        JsonUtils.addFieldAsNanos(sb, "duplicate_window", this.duplicateWindow);
        if (this.placement != null) {
            JsonUtils.addField(sb, "placement", this.placement);
        }
        if (this.mirror != null) {
            JsonUtils.addField(sb, "mirror", this.mirror);
        }
        JsonUtils.addJsons(sb, "sources", this.sources);
        JsonUtils.addFldWhenTrue(sb, "sealed", this.sealed);
        JsonUtils.addFldWhenTrue(sb, "allow_rollup_hdrs", this.allowRollup);
        JsonUtils.addFldWhenTrue(sb, "deny_delete", this.denyDelete);
        JsonUtils.addFldWhenTrue(sb, "deny_purge", this.denyPurge);
        return JsonUtils.endJson(sb).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getSubjects() {
        return this.subjects;
    }

    public DiscardPolicy getDiscardPolicy() {
        return this.discardPolicy;
    }

    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    public long getMaxConsumers() {
        return this.maxConsumers;
    }

    public long getMaxMsgs() {
        return this.maxMsgs;
    }

    public long getMaxMsgsPerSubject() {
        return this.maxMsgsPerSubject;
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public long getMaxMsgSize() {
        return this.maxMsgSize;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public boolean getNoAck() {
        return this.noAck;
    }

    public String getTemplateOwner() {
        return this.templateOwner;
    }

    public Duration getDuplicateWindow() {
        return this.duplicateWindow;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public boolean getSealed() {
        return this.sealed;
    }

    public boolean getAllowRollup() {
        return this.allowRollup;
    }

    public boolean getDenyDelete() {
        return this.denyDelete;
    }

    public boolean getDenyPurge() {
        return this.denyPurge;
    }

    public String toString() {
        return "StreamConfiguration{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", subjects=" + this.subjects + ", retentionPolicy=" + (Object)((Object)this.retentionPolicy) + ", maxConsumers=" + this.maxConsumers + ", maxMsgs=" + this.maxMsgs + ", maxMsgsPerSubject=" + this.maxMsgsPerSubject + ", maxBytes=" + this.maxBytes + ", maxAge=" + this.maxAge + ", maxMsgSize=" + this.maxMsgSize + ", storageType=" + (Object)((Object)this.storageType) + ", replicas=" + this.replicas + ", noAck=" + this.noAck + ", template='" + this.templateOwner + '\'' + ", discardPolicy=" + (Object)((Object)this.discardPolicy) + ", duplicateWindow=" + this.duplicateWindow + ", " + JsonUtils.objectString("mirror", this.mirror) + ", " + JsonUtils.objectString("placement", this.placement) + ", sources=" + this.sources + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StreamConfiguration sc) {
        return new Builder(sc);
    }

    public static class Builder {
        private String name = null;
        private String description = null;
        private final List<String> subjects = new ArrayList<String>();
        private RetentionPolicy retentionPolicy = RetentionPolicy.Limits;
        private long maxConsumers = -1L;
        private long maxMsgs = -1L;
        private long maxMsgsPerSubject = -1L;
        private long maxBytes = -1L;
        private Duration maxAge = Duration.ZERO;
        private long maxMsgSize = -1L;
        private StorageType storageType = StorageType.File;
        private int replicas = 1;
        private boolean noAck = false;
        private String templateOwner = null;
        private DiscardPolicy discardPolicy = DiscardPolicy.Old;
        private Duration duplicateWindow = Duration.ZERO;
        private Placement placement = null;
        private Mirror mirror = null;
        private final List<Source> sources = new ArrayList<Source>();
        private boolean sealed = false;
        private boolean allowRollup = false;
        private boolean denyDelete = false;
        private boolean denyPurge = false;

        public Builder() {
        }

        public Builder(StreamConfiguration sc) {
            if (sc != null) {
                this.name = sc.name;
                this.description = sc.description;
                this.subjects(sc.subjects);
                this.retentionPolicy = sc.retentionPolicy;
                this.maxConsumers = sc.maxConsumers;
                this.maxMsgs = sc.maxMsgs;
                this.maxMsgsPerSubject = sc.maxMsgsPerSubject;
                this.maxBytes = sc.maxBytes;
                this.maxAge = sc.maxAge;
                this.maxMsgSize = sc.maxMsgSize;
                this.storageType = sc.storageType;
                this.replicas = sc.replicas;
                this.noAck = sc.noAck;
                this.templateOwner = sc.templateOwner;
                this.discardPolicy = sc.discardPolicy;
                this.duplicateWindow = sc.duplicateWindow;
                this.placement = sc.placement;
                this.mirror = sc.mirror;
                this.sources(sc.sources);
                this.sealed = sc.sealed;
                this.allowRollup = sc.allowRollup;
                this.denyDelete = sc.denyDelete;
                this.denyPurge = sc.denyPurge;
            }
        }

        public Builder name(String name) {
            this.name = Validator.validateStreamName(name, false);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder subjects(String ... subjects) {
            this.subjects.clear();
            return this.addSubjects(subjects);
        }

        public Builder subjects(Collection<String> subjects) {
            this.subjects.clear();
            return this.addSubjects(subjects);
        }

        public Builder addSubjects(String ... subjects) {
            if (subjects != null) {
                return this.addSubjects(Arrays.asList(subjects));
            }
            return this;
        }

        public Builder addSubjects(Collection<String> subjects) {
            if (subjects != null) {
                for (String sub : subjects) {
                    if (sub == null || this.subjects.contains(sub)) continue;
                    this.subjects.add(sub);
                }
            }
            return this;
        }

        public Builder retentionPolicy(RetentionPolicy policy) {
            this.retentionPolicy = policy == null ? RetentionPolicy.Limits : policy;
            return this;
        }

        public Builder maxConsumers(long maxConsumers) {
            this.maxConsumers = Validator.validateMaxConsumers(maxConsumers);
            return this;
        }

        public Builder maxMessages(long maxMsgs) {
            this.maxMsgs = Validator.validateMaxMessages(maxMsgs);
            return this;
        }

        public Builder maxMessagesPerSubject(long maxMsgsPerSubject) {
            this.maxMsgsPerSubject = Validator.validateMaxMessagesPerSubject(maxMsgsPerSubject);
            return this;
        }

        public Builder maxBytes(long maxBytes) {
            this.maxBytes = Validator.validateMaxBytes(maxBytes);
            return this;
        }

        public Builder maxAge(Duration maxAge) {
            this.maxAge = Validator.validateDurationNotRequiredGtOrEqZero(maxAge, Duration.ZERO);
            return this;
        }

        public Builder maxAge(long maxAgeMillis) {
            this.maxAge = Validator.validateDurationNotRequiredGtOrEqZero(maxAgeMillis);
            return this;
        }

        public Builder maxMsgSize(long maxMsgSize) {
            this.maxMsgSize = Validator.validateMaxMessageSize(maxMsgSize);
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.storageType = storageType == null ? StorageType.File : storageType;
            return this;
        }

        public Builder replicas(int replicas) {
            this.replicas = Validator.validateNumberOfReplicas(replicas);
            return this;
        }

        public Builder noAck(boolean noAck) {
            this.noAck = noAck;
            return this;
        }

        public Builder templateOwner(String templateOwner) {
            this.templateOwner = Validator.emptyAsNull(templateOwner);
            return this;
        }

        public Builder discardPolicy(DiscardPolicy policy) {
            this.discardPolicy = policy == null ? DiscardPolicy.Old : policy;
            return this;
        }

        public Builder duplicateWindow(Duration window) {
            this.duplicateWindow = Validator.validateDurationNotRequiredGtOrEqZero(window, Duration.ZERO);
            return this;
        }

        public Builder duplicateWindow(long windowMillis) {
            this.duplicateWindow = Validator.validateDurationNotRequiredGtOrEqZero(windowMillis);
            return this;
        }

        public Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public Builder mirror(Mirror mirror) {
            this.mirror = mirror;
            return this;
        }

        public Builder sources(Source ... sources) {
            this.sources.clear();
            return this.addSources(sources);
        }

        public Builder sources(Collection<Source> sources) {
            this.sources.clear();
            return this.addSources(sources);
        }

        public Builder addSources(Source ... sources) {
            return this.addSources(Arrays.asList(sources));
        }

        public Builder addSources(Collection<Source> sources) {
            if (sources != null) {
                for (Source source : sources) {
                    if (source == null || this.sources.contains(source)) continue;
                    this.sources.add(source);
                }
            }
            return this;
        }

        protected Builder sealed(boolean sealed) {
            this.sealed = sealed;
            return this;
        }

        public Builder allowRollup(boolean allowRollup) {
            this.allowRollup = allowRollup;
            return this;
        }

        public Builder denyDelete(boolean denyDelete) {
            this.denyDelete = denyDelete;
            return this;
        }

        public Builder denyPurge(boolean denyPurge) {
            this.denyPurge = denyPurge;
            return this;
        }

        public StreamConfiguration build() {
            return new StreamConfiguration(this);
        }
    }
}

