/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cms.verify.bc;

import com.huawei.cms.verify.bc.Algorithm;
import com.huawei.cms.verify.bc.CmsValidationException;
import com.huawei.cms.verify.bc.CmscbbErr;
import com.huawei.cms.verify.bc.CommonUtil;
import com.huawei.cms.verify.bc.CrlWrapper;
import com.huawei.cms.verify.bc.HashAlgorithm;
import com.huawei.cms.verify.bc.HuaweiObjectIdentifiers;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Date;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jce.provider.AnnotatedException;
import org.bouncycastle.operator.ContentVerifierProvider;

public class CertWrapper {
    private final X509CertificateHolder cert;
    private final byte[] sha256Fp;
    private final byte[] aki;
    private final byte[] ski;
    private final KeyUsage keyUsage;
    private final BasicConstraints basicConstraints;
    private final Algorithm certSignAlgo;
    private final boolean linkCert;
    private final boolean selfSigned;
    private CmscbbErr sigVerification;
    private CmscbbErr statusVerification;
    private CertWrapper issuerCert;

    public CertWrapper(byte[] certEncoding) throws CmsValidationException, AnnotatedException {
        this(CertWrapper.toX509CertificateHolder(certEncoding));
    }

    public CertWrapper(X509CertificateHolder cert) throws CmsValidationException, AnnotatedException {
        CommonUtil.requireNonNull(cert, "cert");
        this.cert = cert;
        try {
            Extension extn = cert.getExtension(Extension.subjectKeyIdentifier);
            this.ski = extn == null ? null : ASN1OctetString.getInstance((Object)extn.getParsedValue()).getOctets();
            extn = cert.getExtension(Extension.authorityKeyIdentifier);
            this.aki = extn == null ? null : AuthorityKeyIdentifier.getInstance((Object)extn.getParsedValue()).getKeyIdentifier();
            this.keyUsage = KeyUsage.getInstance((Object)this.getCertKeyUsage(Extension.keyUsage).getParsedValue());
            this.basicConstraints = BasicConstraints.getInstance((Object)this.getCertKeyUsage(Extension.basicConstraints).getParsedValue());
            this.certSignAlgo = Algorithm.ofAlgId(cert.getSignatureAlgorithm()).orElse(null);
            this.linkCert = cert.getExtension(HuaweiObjectIdentifiers.ID_HW_EXT_LINKCERT) != null;
            this.selfSigned = this.isSelfSignedCert(cert);
            this.sha256Fp = HashAlgorithm.SHA256.hash(cert.getEncoded());
        }
        catch (IOException e) {
            throw new CmsValidationException(CmscbbErr.PKI_CERT_DECODE, e.getMessage());
        }
    }

    private static X509CertificateHolder toX509CertificateHolder(byte[] crlEncoding) throws CmsValidationException {
        try {
            return new X509CertificateHolder(crlEncoding);
        }
        catch (IOException ex) {
            throw new CmsValidationException(CmscbbErr.PKI_CERT_DECODE, ex.getMessage());
        }
    }

    private Extension getCertKeyUsage(ASN1ObjectIdentifier asn1Obj) throws AnnotatedException {
        Extension extension = this.cert.getExtension(asn1Obj);
        if (extension != null) {
            return extension;
        }
        throw new AnnotatedException("Certificate does not have keyUsage.");
    }

    private boolean isSelfSignedCert(X509CertificateHolder cert) {
        boolean isSelfSigned = cert.getSubject().equals((Object)cert.getIssuer());
        if (isSelfSigned && this.aki != null) {
            isSelfSigned = Arrays.equals(this.ski, this.aki);
        }
        return isSelfSigned && this.verifySignature(this);
    }

    public boolean isCA() {
        return this.basicConstraints.isCA();
    }

    public byte[] getSha256Fp() {
        return (byte[])this.sha256Fp.clone();
    }

    public boolean isValidOn(Date date) {
        return this.cert.isValidOn(date);
    }

    public boolean isSelfSigned() {
        return this.selfSigned;
    }

    public byte[] getAki() {
        return this.aki == null ? new byte[]{} : (byte[])this.aki.clone();
    }

    public byte[] getSki() {
        return (byte[])this.ski.clone();
    }

    public Algorithm getCertSignAlgo() {
        return this.certSignAlgo;
    }

    public boolean hasUsages(int usages) {
        return this.keyUsage.hasUsages(usages);
    }

    public BasicConstraints getBasicConstraints() {
        return this.basicConstraints;
    }

    public X500Name getIssuer() {
        return this.cert.getIssuer();
    }

    public X500Name getSubject() {
        return this.cert.getSubject();
    }

    public BigInteger getSerialNumber() {
        return this.cert.getSerialNumber();
    }

    public boolean matchSubjectKeyIdentifier(byte[] ski) {
        return Arrays.equals(ski, this.ski);
    }

    public CmscbbErr getSigVerification() {
        return this.sigVerification;
    }

    public void setSigVerification(CmscbbErr sigVerification) {
        this.sigVerification = sigVerification;
    }

    public CmscbbErr getStatusVerification() {
        return this.statusVerification;
    }

    public void setStatusVerification(CmscbbErr statusVerification) {
        this.statusVerification = statusVerification;
    }

    public Date getNotBefore() {
        return this.cert.getNotBefore();
    }

    public Date getNotAfter() {
        return this.cert.getNotAfter();
    }

    public X509CertificateHolder getCert() {
        return this.cert;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.cert.getSubjectPublicKeyInfo();
    }

    public boolean isLinkCert() {
        return this.linkCert;
    }

    public CertWrapper getIssuerCert() {
        return this.issuerCert;
    }

    public void setIssuerCert(CertWrapper issuerCert) {
        this.issuerCert = issuerCert;
    }

    public boolean isCertIssuer(CertWrapper cert) {
        if (!this.basicConstraints.isCA()) {
            return false;
        }
        if (!this.hasUsages(4)) {
            return false;
        }
        if (this.thisPathLenSmaller(cert)) {
            return false;
        }
        if (!cert.getIssuer().equals((Object)this.getSubject())) {
            return false;
        }
        if (!this.matchSubjectKeyIdentifier(cert.getAki())) {
            return false;
        }
        return this.cert.isValidOn(cert.getNotBefore());
    }

    private boolean thisPathLenSmaller(CertWrapper otherCert) {
        BigInteger bn;
        int minPathLenOfCa = 0;
        if (otherCert.getBasicConstraints().isCA()) {
            BigInteger bi = otherCert.basicConstraints.getPathLenConstraint();
            minPathLenOfCa = bi == null ? Integer.MAX_VALUE : bi.intValue() + 1;
        }
        int thisPathLen = (bn = this.basicConstraints.getPathLenConstraint()) == null ? Integer.MAX_VALUE : bn.intValue();
        return thisPathLen < minPathLenOfCa;
    }

    public boolean verifySignature(CertWrapper otherCert) {
        try {
            ContentVerifierProvider cvp = CommonUtil.getContentVerifierProvider(this.getSubjectPublicKeyInfo());
            return otherCert.cert.isSignatureValid(cvp);
        }
        catch (InvalidKeyException | CertException e) {
            return false;
        }
    }

    public boolean verifySignature(CrlWrapper crl) throws CmsValidationException {
        try {
            ContentVerifierProvider cvp = CommonUtil.getContentVerifierProvider(this.getSubjectPublicKeyInfo());
            return crl.getCrl().isSignatureValid(cvp);
        }
        catch (InvalidKeyException | CertException e) {
            crl.setVerified(Boolean.FALSE);
            throw new CmsValidationException(CmscbbErr.PKI_CRL_INVALID);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.sha256Fp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CertWrapper)) {
            return false;
        }
        return Arrays.equals(this.sha256Fp, ((CertWrapper)obj).sha256Fp);
    }
}

