/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.enums;

import java.util.Arrays;

public enum SafeEncodeAlgorithmEnum {
    AES(128),
    SHA(256),
    EC(256),
    ECDSA(256),
    ECDH(256),
    RSA(2048),
    DSA(2048),
    DH(2048);

    private final int bits;

    public static boolean isSafe(String algorithmName, int bits) {
        return Arrays.stream(SafeEncodeAlgorithmEnum.values()).filter(algorithm -> algorithmName.startsWith(algorithm.name())).findFirst().map(SafeEncodeAlgorithmEnum::getBits).map(algorithmBits -> bits >= algorithmBits).orElse(false);
    }

    private SafeEncodeAlgorithmEnum(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }
}

