/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.keytool.services.impls;

import com.huawei.ism.tool.certbase.annotations.FieldDesc;
import com.huawei.ism.tool.certbase.entitys.CertManageBaseEntity;
import com.huawei.ism.tool.certbase.entitys.CertReqEntity;
import com.huawei.ism.tool.certbase.entitys.ExportCrtEntity;
import com.huawei.ism.tool.certbase.keytool.services.ICertificateManageService;
import com.huawei.ism.tool.certbase.utils.ReflectUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class CertificateManageService
implements ICertificateManageService {
    private static final Logger log = LoggerFactory.getLogger(CertificateManageService.class);
    private static final char SPACE = ' ';
    private static final String QUOTE = "\"";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean generateKeyStore(CertReqEntity certReqEntity) {
        Process execProcess;
        String genCommand;
        block5: {
            genCommand = this.buildKeyToolCommand(certReqEntity);
            execProcess = null;
            if (!genCommand.isEmpty()) break block5;
            log.info("some parameters is invalid while genkeypair.");
            boolean bl = false;
            this.exitProcess(execProcess);
            return bl;
        }
        try {
            execProcess = Runtime.getRuntime().exec(genCommand);
            boolean bl = this.writePsdAndWait(certReqEntity, execProcess, 2) == 0 && this.isFileExists(certReqEntity.getKeyStoreFile());
            this.exitProcess(execProcess);
            return bl;
        }
        catch (Exception e) {
            try {
                log.error("error to gen keypair.", (Throwable)e);
                this.exitProcess(execProcess);
            }
            catch (Throwable throwable) {
                this.exitProcess(execProcess);
                throw throwable;
            }
        }
        return false;
    }

    private int writePsdAndWait(CertManageBaseEntity certReqEntity, Process execProcess, int psdWriteTimes) throws IOException, InterruptedException {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(execProcess.getInputStream(), Charset.defaultCharset()));
             BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(execProcess.getOutputStream(), Charset.defaultCharset()));){
            for (int time = 0; time < psdWriteTimes; ++time) {
                wr.write(certReqEntity.getStorePass());
                wr.newLine();
                wr.flush();
            }
        }
        return execProcess.waitFor();
    }

    private void exitProcess(Process execProcess) {
        if (execProcess != null) {
            execProcess.destroyForcibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exportPublicCrt(ExportCrtEntity exportCrtEntity) {
        Process execProcess;
        String genCommand;
        block5: {
            genCommand = this.buildCommandStr(exportCrtEntity);
            execProcess = null;
            if (!genCommand.isEmpty()) break block5;
            log.info("some parameters is invalid while export public cert.");
            boolean bl = false;
            this.exitProcess(execProcess);
            return bl;
        }
        try {
            execProcess = Runtime.getRuntime().exec(genCommand);
            boolean bl = this.writePsdAndWait(exportCrtEntity, execProcess, 1) == 0 && this.isFileExists(exportCrtEntity.getDestFile());
            this.exitProcess(execProcess);
            return bl;
        }
        catch (Exception e) {
            try {
                log.error("error to export public cert.", (Throwable)e);
                this.exitProcess(execProcess);
            }
            catch (Throwable throwable) {
                this.exitProcess(execProcess);
                throw throwable;
            }
        }
        return false;
    }

    private boolean isFileExists(String destFile) {
        return FileUtils.getFile(destFile.replace(QUOTE, "")).exists();
    }

    @Override
    public boolean exportPrivateKey(ExportCrtEntity exportCrtEntity) {
        String genCommand = this.buildCommandStr(exportCrtEntity);
        try {
            if (genCommand.isEmpty()) {
                log.info("some parameters is invalid while export private key.");
                return false;
            }
            return this.savePrivateKey(exportCrtEntity).isPresent();
        }
        catch (Exception e) {
            log.error("error to export privateKey", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isCertRevoked(String crtLoc, List<String> crlList) {
        if (ObjectUtils.isEmpty((Object)crtLoc) || ObjectUtils.isEmpty(crlList) || !FileUtils.getFile(crtLoc).exists()) {
            log.info("input param invalid");
            return false;
        }
        return crlList.stream().anyMatch(crl -> this.isCrtRevoked(crtLoc, (String)crl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<X509Certificate> getCrtInfo(String certPath) {
        try (FileInputStream in = new FileInputStream(certPath);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
            log.info("cert info {}", (Object)cert.toString());
            Optional<X509Certificate> optional = Optional.ofNullable(cert);
            return optional;
        }
        catch (FileNotFoundException e) {
            log.error("error to get cert");
            return Optional.empty();
        }
        catch (Exception e) {
            log.error("error to get cert", (Throwable)e);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isCrtRevoked(String certificatePath, String crlPath) {
        if (!FileUtils.getFile(crlPath).exists()) {
            return false;
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(new FileInputStream(new File(certificatePath)));
            try (DataInputStream inStream = new DataInputStream(new FileInputStream(FileUtils.getFile(crlPath)));){
                X509CRL crl = (X509CRL)cf.generateCRL(inStream);
                X509CRLEntry revokedCertificate = crl.getRevokedCertificate(certificate.getSerialNumber());
                boolean bl = revokedCertificate != null;
                return bl;
            }
        }
        catch (Exception e) {
            log.error("check cert crl fail", (Throwable)e);
            return false;
        }
    }

    public String buildKeyToolCommand(CertManageBaseEntity buildEntity) {
        if (this.isEntityInvalid(buildEntity)) {
            return "";
        }
        return this.buildCommandStr(buildEntity);
    }

    private String buildCommandStr(CertManageBaseEntity buildEntity) {
        List<Field> fieldList = this.getDeclaredFields(buildEntity);
        StringBuilder command = new StringBuilder();
        fieldList.forEach(field -> this.appendCommand(buildEntity, command, (Field)field));
        buildEntity.getExtendParam().forEach(param -> command.append((String)param).append(' '));
        if (!this.isGenKeyRequest(buildEntity)) {
            return command.toString().trim();
        }
        String dname = this.buildExtendField(buildEntity, fieldList);
        command.append("-dname ").append(dname);
        return command.toString().trim();
    }

    private void appendCommand(CertManageBaseEntity buildEntity, StringBuilder command, Field field) {
        FieldDesc fieldDesc = field.getAnnotation(FieldDesc.class);
        if (fieldDesc == null) {
            return;
        }
        if (fieldDesc.isSensitiveField()) {
            return;
        }
        String fieldMapColumn = fieldDesc.fieldMapName();
        Object fieldValue = ReflectUtils.getFieldValue(buildEntity, field);
        if (!fieldDesc.isExtendField() && !ObjectUtils.isEmpty((Object)fieldValue)) {
            if (fieldDesc.isAutoFillQuote()) {
                command.append(fieldMapColumn).append(' ').append(QUOTE).append(fieldValue).append(QUOTE).append(' ');
            } else {
                command.append(fieldMapColumn).append(' ').append(fieldValue).append(' ');
            }
        }
    }

    private String buildExtendField(CertManageBaseEntity reqEntity, List<Field> fieldList) {
        StringBuilder builder = new StringBuilder(QUOTE);
        fieldList.forEach(field -> {
            FieldDesc fieldDesc = field.getAnnotation(FieldDesc.class);
            if (fieldDesc == null) {
                return;
            }
            String fieldMapColumn = fieldDesc.fieldMapName();
            Object fieldValue = ReflectUtils.getFieldValue(reqEntity, field);
            if (fieldDesc.isExtendField()) {
                Object fieldValueStr = ObjectUtils.defaultIfNull((Object)fieldValue, (Object)"Unknown");
                builder.append(fieldMapColumn).append('=').append(fieldValueStr).append(',');
            }
        });
        builder.deleteCharAt(builder.length() - 1);
        builder.append(QUOTE);
        return builder.toString();
    }

    private boolean isGenKeyRequest(CertManageBaseEntity reqEntity) {
        return reqEntity instanceof CertReqEntity;
    }

    private boolean isEntityInvalid(CertManageBaseEntity reqEntity) {
        List<Field> declaredFields = this.getDeclaredFields(reqEntity);
        return declaredFields.stream().anyMatch(field -> this.isFieldInValid(reqEntity, (Field)field));
    }

    private List<Field> getDeclaredFields(CertManageBaseEntity reqEntity) {
        List<Field> allFields = ReflectUtils.getFieldOfClassAndParent(reqEntity);
        allFields.sort((field0, field1) -> {
            FieldDesc descA = field0.getAnnotation(FieldDesc.class);
            FieldDesc descB = field1.getAnnotation(FieldDesc.class);
            if (descA == null || descB == null) {
                return 0;
            }
            return descA.columnIndex() - descB.columnIndex();
        });
        return allFields;
    }

    private String replacePathQuote(String path) {
        return path.replace(QUOTE, "");
    }

    private boolean isFieldInValid(CertManageBaseEntity buildEntity, Field field) {
        Object fieldValue;
        FieldDesc fieldDesc = field.getAnnotation(FieldDesc.class);
        if (fieldDesc == null) {
            return false;
        }
        String checkRegex = fieldDesc.validRegex();
        boolean isFieldValid = this.isFieldValid(checkRegex, fieldValue = ReflectUtils.getFieldValue(buildEntity, field));
        if (!isFieldValid) {
            log.warn("param {} is invalid.", (Object)field.getName());
        }
        return !isFieldValid;
    }

    private boolean isFieldValid(String checkRegex, Object fieldValue) {
        return StringUtils.isEmpty((CharSequence)checkRegex) || fieldValue != null && fieldValue.toString().matches(checkRegex);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<KeyStore> getKeyStore(String keyStorePath, String psd) {
        try (FileInputStream is = new FileInputStream(this.replacePathQuote(keyStorePath));){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(is, psd.toCharArray());
            Optional<KeyStore> optional = Optional.ofNullable(ks);
            return optional;
        }
        catch (FileNotFoundException e) {
            log.error("get key failed.");
            return Optional.empty();
        }
        catch (Exception e) {
            log.error("get key failed.", (Throwable)e);
            return Optional.empty();
        }
    }

    public Optional<PrivateKey> savePrivateKey(ExportCrtEntity exportCrtEntity) {
        try {
            BASE64Encoder encoder = new BASE64Encoder();
            Optional<KeyStore> kStore = this.getKeyStore(exportCrtEntity.getKeyStoreFile(), exportCrtEntity.getStorePass());
            PrivateKey key = (PrivateKey)kStore.get().getKey(exportCrtEntity.getAlias(), exportCrtEntity.getKeyPass().toCharArray());
            String encoded = encoder.encode(key.getEncoded());
            String privkey = "-----BEGIN RSA PRIVATE KEY-----" + System.lineSeparator();
            privkey = privkey + encoded + System.lineSeparator();
            privkey = privkey + "-----END RSA PRIVATE KEY-----";
            FileUtils.write(FileUtils.getFile(this.replacePathQuote(exportCrtEntity.getDestFile())), (CharSequence)privkey, Charset.defaultCharset());
            return Optional.of(key);
        }
        catch (Exception e) {
            log.error("write file error.", (Throwable)e);
            return Optional.empty();
        }
    }
}

