/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.utils;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.certbase.annotations.FieldDesc;
import com.huawei.ism.tool.certbase.entitys.CertManageBaseEntity;
import com.huawei.ism.tool.certbase.entitys.CertReqEntity;
import com.huawei.ism.tool.certbase.entitys.ExportCrtEntity;
import com.huawei.ism.tool.certbase.keytool.services.ICertificateManageService;
import com.huawei.ism.tool.certbase.keytool.services.impls.CertificateManageService;
import com.huawei.ism.tool.certbase.utils.ReflectUtils;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertGenerateUtil {
    private static final Logger log = LoggerFactory.getLogger(CertGenerateUtil.class);
    private static final ICertificateManageService INSTANCE = new CertificateManageService();
    private static final String DEFAULT_CERT_NAME = "buildInCert";

    public static String getDefaultCertPath() {
        return System.getProperty("user.dir") + File.separator + "certs";
    }

    private static <T extends CertManageBaseEntity> T transParamToConfigEntity(String operation, JSONObject requestParam) {
        CertManageBaseEntity configEntity = CertGenerateUtil.buildEntity(operation);
        return CertGenerateUtil.fillParams(configEntity, requestParam);
    }

    private static <T extends CertManageBaseEntity> T fillParams(CertManageBaseEntity configEntity, JSONObject requestParam) {
        List<Field> allField = ReflectUtils.getFieldOfClassAndParent(configEntity);
        allField.forEach(field -> CertGenerateUtil.fillParamToEntity(configEntity, requestParam, field));
        return (T)configEntity;
    }

    public static boolean generateKeyStore(String storeFileSaveLoccation, String storePass) {
        CertManageBaseEntity entity = ((CertReqEntity.CertReqEntityBuilder)((CertReqEntity.CertReqEntityBuilder)((CertReqEntity.CertReqEntityBuilder)CertReqEntity.builder().keyStoreFile(storeFileSaveLoccation)).storePass(storePass)).keyPass(storePass)).build();
        return INSTANCE.generateKeyStore((CertReqEntity)entity);
    }

    public static boolean exportPublicCrt(String keyStoreFile, String storePass, String crtSaveLocation) {
        CertManageBaseEntity entity = ((ExportCrtEntity.ExportCrtEntityBuilder)((ExportCrtEntity.ExportCrtEntityBuilder)((ExportCrtEntity.ExportCrtEntityBuilder)((ExportCrtEntity.ExportCrtEntityBuilder)((CertManageBaseEntity.CertManageBaseEntityBuilder)ExportCrtEntity.builder().destFile(crtSaveLocation)).storePass(storePass)).keyPass(storePass)).keyStoreFile(keyStoreFile)).keyOperation("-exportcert")).build();
        entity.getExtendParam().add("-rfc");
        return INSTANCE.exportPublicCrt((ExportCrtEntity)entity);
    }

    public static boolean exportPrivateKey(String keyStoreFile, String storePass, String crtSaveLocation) {
        CertManageBaseEntity entity = ((ExportCrtEntity.ExportCrtEntityBuilder)((ExportCrtEntity.ExportCrtEntityBuilder)((ExportCrtEntity.ExportCrtEntityBuilder)((ExportCrtEntity.ExportCrtEntityBuilder)((CertManageBaseEntity.CertManageBaseEntityBuilder)ExportCrtEntity.builder().destFile(crtSaveLocation)).storePass(storePass)).keyPass(storePass)).keyOperation("-exportprivkey")).keyStoreFile(keyStoreFile)).build();
        return INSTANCE.exportPrivateKey((ExportCrtEntity)entity);
    }

    private static void fillParamToEntity(CertManageBaseEntity configEntity, JSONObject requestParam, Field field) {
        FieldDesc desc = field.getAnnotation(FieldDesc.class);
        if (desc == null) {
            return;
        }
        Object pValue = requestParam.get((Object)desc.fieldMapName());
        field.setAccessible(true);
        try {
            if (pValue == null) {
                log.warn("set field value is null {}", (Object)field.getName());
                return;
            }
            field.set(configEntity, pValue);
        }
        catch (IllegalAccessException e) {
            log.warn("set field value error {}", (Object)field.getName());
        }
    }

    private static CertManageBaseEntity buildEntity(String operation) {
        if (CertGenerateUtil.isGenKeyPair(operation)) {
            return ((CertReqEntity.CertReqEntityBuilder)CertReqEntity.builder().keyOperation(operation)).build();
        }
        return ((ExportCrtEntity.ExportCrtEntityBuilder)ExportCrtEntity.builder().keyOperation(operation)).build();
    }

    public static boolean operateCertGen(String operationType, String paramsStr) {
        JSONObject param = JSONObject.parseObject((String)paramsStr);
        return CertGenerateUtil.operateCertGen(operationType, param);
    }

    public static boolean operateCertGen(String operationType, JSONObject param) {
        if (CertGenerateUtil.isGenKeyPair(operationType)) {
            CertReqEntity entity = (CertReqEntity)CertGenerateUtil.transParamToConfigEntity(operationType, param);
            return INSTANCE.generateKeyStore(entity);
        }
        if (CertGenerateUtil.isExportPublicCert(operationType)) {
            ExportCrtEntity exportCrtEntity = (ExportCrtEntity)CertGenerateUtil.transParamToConfigEntity(operationType, param);
            exportCrtEntity.getExtendParam().add("-rfc");
            return INSTANCE.exportPublicCrt(exportCrtEntity);
        }
        ExportCrtEntity exportCrtEntity = (ExportCrtEntity)CertGenerateUtil.transParamToConfigEntity(operationType, param);
        return INSTANCE.exportPrivateKey(exportCrtEntity);
    }

    private static boolean isExportPublicCert(String operationType) {
        return "-exportcert".equalsIgnoreCase(operationType);
    }

    private static boolean isGenKeyPair(String operationType) {
        return "-genkeypair".equalsIgnoreCase(operationType);
    }

    public static boolean generateCertSuit(String pwd) {
        if (!CertGenerateUtil.generateKeyStore(CertGenerateUtil.getDefaultCertStoreLocation(), pwd)) {
            log.error("generate keystore fail.");
            return false;
        }
        if (!CertGenerateUtil.exportPublicCrt(CertGenerateUtil.getDefaultCertStoreLocation(), pwd, CertGenerateUtil.getDefaultPublicCrtPath())) {
            log.error("export crt fail.");
            return false;
        }
        return CertGenerateUtil.exportPrivateKey(CertGenerateUtil.getDefaultCertStoreLocation(), pwd, CertGenerateUtil.getDefaultPrivateCrtPath());
    }

    public static String getDefaultCertStoreLocation() {
        return CertGenerateUtil.getDefaultCertPath() + File.separator + DEFAULT_CERT_NAME + ".keystore";
    }

    public static String getDefaultPublicCrtPath() {
        return CertGenerateUtil.getDefaultCertPath() + File.separator + DEFAULT_CERT_NAME + ".crt";
    }

    public static String getDefaultPrivateCrtPath() {
        return CertGenerateUtil.getDefaultCertPath() + File.separator + DEFAULT_CERT_NAME + ".key";
    }
}

