/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.utils;

import com.huawei.ism.tool.certbase.utils.FileUtils;
import com.huawei.ism.tool.certbase.utils.RevokedCertUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokedCertListLoader {
    private static final Logger log = LoggerFactory.getLogger(RevokedCertListLoader.class);
    private final Collection<X509CRL> x509Crls;

    public void addCrl(String crlPath, Collection<X509Certificate> caCerts) throws CRLException {
        File crlFile = FileUtils.getCanonicalFile(crlPath);
        if (crlFile == null || !crlFile.exists()) {
            throw new CRLException("CRL path is invalid.");
        }
        Path path = crlFile.toPath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            this.addCrlByDir(path, caCerts);
            return;
        }
        this.loadAndVerifyCrl(path, caCerts);
    }

    private void addCrlByDir(Path crlDir, Collection<X509Certificate> caCerts) throws CRLException {
        try (Stream<Path> crlPathStream = Files.list(crlDir);){
            List<Path> crlFiles = crlPathStream.filter(RevokedCertUtil::isCrlFile).collect(Collectors.toList());
            this.addCrlFiles(crlFiles, caCerts);
        }
        catch (IOException e) {
            throw new CRLException("List crl dir error.", e);
        }
    }

    private void addCrlFiles(List<Path> crlFiles, Collection<X509Certificate> caCerts) throws CRLException {
        ArrayList<CRLException> loadCrlErrors = new ArrayList<CRLException>();
        for (Path crlFile : crlFiles) {
            try {
                this.loadAndVerifyCrl(crlFile, caCerts);
            }
            catch (CRLException e) {
                loadCrlErrors.add(e);
            }
        }
        if (!loadCrlErrors.isEmpty()) {
            CRLException crlException = new CRLException("Error occurred when add crl files.");
            loadCrlErrors.forEach(crlException::addSuppressed);
            throw crlException;
        }
    }

    private void loadAndVerifyCrl(Path path, Collection<X509Certificate> caCerts) throws CRLException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            X509CRL crl = RevokedCertUtil.getCrlFromStream(inputStream);
            if (this.x509Crls.contains(crl)) {
                log.warn("The CRL file [{}] is loaded.", (Object)path.getFileName());
                return;
            }
            this.verifyCrl(crl, caCerts);
            this.x509Crls.add(crl);
        }
        catch (IOException | CertificateException e) {
            throw new CRLException("Read crl file error.", e);
        }
    }

    private void verifyCrl(X509CRL crl, Collection<X509Certificate> caCerts) throws CRLException {
        try {
            crl.verify(this.getCrlIssuer(crl, caCerts).getPublicKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new CRLException("Verify CRL signature fail.", e);
        }
    }

    private X509Certificate getCrlIssuer(X509CRL crl, Collection<X509Certificate> caCerts) throws CRLException {
        return caCerts.stream().filter(ca -> ca.getSubjectDN().equals(crl.getIssuerDN())).findFirst().orElseThrow(() -> new CRLException("Not find CRL issuer(CA)."));
    }

    public RevokedCertListLoader(Collection<X509CRL> x509Crls) {
        this.x509Crls = x509Crls;
    }
}

