/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.certbase.utils;

import com.huawei.ism.tool.certbase.utils.FileUtils;
import com.huawei.ism.tool.certbase.utils.RevokedCertListLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokedCertUtil {
    private static final Logger log = LoggerFactory.getLogger(RevokedCertUtil.class);
    static final String CRL_FILE_TYPE = ".crl";
    private static final List<X509CRL> X509_CRL = new ArrayList<X509CRL>();
    private static final RevokedCertListLoader CRL_LOADER = new RevokedCertListLoader(X509_CRL);

    public static boolean verifyCrl(X509CRL crl, Certificate[] certs) {
        if (crl == null) {
            return true;
        }
        if (certs == null) {
            log.warn("certs or crl is null, verify fail.");
            return false;
        }
        for (Certificate cert : certs) {
            X509Certificate x509Certificate;
            X509CRLEntry revokedCertificate;
            if (!(cert instanceof X509Certificate) || (revokedCertificate = crl.getRevokedCertificate((x509Certificate = (X509Certificate)cert).getSerialNumber())) == null) continue;
            log.error("server cert sn {} is revoked.", (Object)x509Certificate.getSerialNumber());
            return false;
        }
        return true;
    }

    public static boolean verifyCrl(List<X509CRL> crls, Certificate[] certs) {
        if (crls == null || crls.isEmpty()) {
            return true;
        }
        for (X509CRL crl : crls) {
            if (RevokedCertUtil.verifyCrl(crl, certs)) continue;
            return false;
        }
        return true;
    }

    public static X509CRL getCrlFromStream(InputStream in) throws CertificateException, CRLException {
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        return (X509CRL)cf.generateCRL(in);
    }

    @Deprecated
    public static void addCrl(String path) {
        File crlFile = FileUtils.getCanonicalFile(path);
        if (crlFile == null || !crlFile.exists()) {
            return;
        }
        if (crlFile.isDirectory()) {
            File[] crls = crlFile.listFiles((dir, name) -> name.endsWith(CRL_FILE_TYPE));
            for (File crl : Objects.requireNonNull(crls)) {
                RevokedCertUtil.loadCrl(crl);
            }
            return;
        }
        if (crlFile.getName().endsWith(CRL_FILE_TYPE)) {
            RevokedCertUtil.loadCrl(crlFile);
        }
    }

    private static void loadCrl(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            X509_CRL.add(RevokedCertUtil.getCrlFromStream(in));
        }
        catch (Exception e) {
            log.error("load crl error.");
        }
    }

    public static void addCrl(String crlPath, Collection<X509Certificate> caCerts) throws CRLException {
        CRL_LOADER.addCrl(crlPath, caCerts);
    }

    static boolean isCrlFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]) && path.toString().toLowerCase(Locale.ROOT).endsWith(CRL_FILE_TYPE);
    }

    public static List<X509CRL> getX509Crl() {
        return X509_CRL;
    }

    private RevokedCertUtil() {
    }
}

