/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.type;

import com.huawei.fitframework.core.common.type.support.DefaultTypeMatcherContext;
import com.huawei.fitframework.core.common.type.support.TypeMatcherDispatcher;
import com.huawei.fitframework.core.common.util.Validation;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.Supplier;

public interface TypeMatcher {
    public boolean match(Type var1);

    public static boolean match(Type currentType, Type expectedType) {
        return TypeMatcher.match(currentType, expectedType, null);
    }

    public static boolean match(Type currentType, Type expectedType, Context context) {
        Validation.notNull(currentType, "The object type to match cannot be null.", new Object[0]);
        Validation.notNull(expectedType, "The expected type to match cannot be null.", new Object[0]);
        return new TypeMatcherDispatcher(currentType, context).match(expectedType);
    }

    public static interface Factory {
        public TypeMatcher create(Type var1, Context var2);
    }

    public static interface Context {
        public static Context empty() {
            return DefaultTypeMatcherContext.EMPTY;
        }

        public Optional<Type> getVariableValue(String var1);

        public static Builder builder() {
            return new DefaultTypeMatcherContext.Builder();
        }

        public static interface Builder {
            default public Builder setVariableValue(String name, Type value) {
                return this.setVariableValue(name, () -> value);
            }

            public Builder setVariableValue(String var1, Supplier<Type> var2);

            public Context build();
        }
    }
}

