/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.type.support;

import com.huawei.fitframework.core.common.type.TypeMatcher;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class DefaultTypeMatcherContext
implements TypeMatcher.Context {
    public static final DefaultTypeMatcherContext EMPTY = new DefaultTypeMatcherContext(Collections.emptyMap());
    private final Map<String, Supplier<Type>> variableValues;

    private DefaultTypeMatcherContext(Map<String, Supplier<Type>> variableValues) {
        this.variableValues = variableValues;
    }

    @Override
    public Optional<Type> getVariableValue(String variableName) {
        Supplier<Type> supplier = this.variableValues.get(variableName);
        if (supplier == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(supplier.get());
    }

    public static class Builder
    implements TypeMatcher.Context.Builder {
        private final Map<String, Supplier<Type>> variableValues = new HashMap<String, Supplier<Type>>();

        @Override
        public TypeMatcher.Context.Builder setVariableValue(String name, Supplier<Type> valueSupplier) {
            this.variableValues.put(name, valueSupplier);
            return this;
        }

        @Override
        public TypeMatcher.Context build() {
            return new DefaultTypeMatcherContext(this.variableValues);
        }
    }
}

