/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.type.support;

import com.huawei.fitframework.core.common.type.TypeMatcher;
import com.huawei.fitframework.core.common.type.annotation.MatchTypes;
import com.huawei.fitframework.core.common.type.support.ClassMatcher;
import com.huawei.fitframework.core.common.type.support.ClassParameterizedTypeMatcher;
import com.huawei.fitframework.core.common.type.support.ParameterizedTypeClassMatcher;
import com.huawei.fitframework.core.common.type.support.ParameterizedTypeMatcher;
import com.huawei.fitframework.core.common.type.support.TypeVariableTypeMatcher;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class TypeMatcherDispatcher
implements TypeMatcher {
    private static final Map<Class<?>, Map<Class<?>, TypeMatcher.Factory>> FACTORIES = new HashMap();
    private final Type currentType;
    private final TypeMatcher.Context context;

    public TypeMatcherDispatcher(Type currentType, TypeMatcher.Context context) {
        this.currentType = Validation.notNull(currentType, "The object type to match cannot be null.", new Object[0]);
        this.context = ObjectUtils.nullIf(context, TypeMatcher.Context.empty());
    }

    private static void addFactory(Class<?> matcherClass) {
        Validation.notNull(matcherClass, "No class to add factory.", new Object[0]);
        MatchTypes annotation = matcherClass.getDeclaredAnnotation(MatchTypes.class);
        Validation.notNull(annotation, "No 'MatchTypes' annotation on class. [class={0}]", matcherClass.getName());
        TypeMatcher.Factory factory = ReflectionUtils.instantiate(annotation.factory());
        FACTORIES.computeIfAbsent(annotation.current(), key -> new HashMap()).put(annotation.expected(), factory);
    }

    private static Optional<TypeMatcher.Factory> getFactory(Class<?> objectClassType, Class<?> expectedClassType) {
        return TypeMatcherDispatcher.map(FACTORIES, objectClassType).flatMap(factories -> TypeMatcherDispatcher.map(factories, expectedClassType));
    }

    private static <V> Optional<V> map(Map<Class<?>, V> map, Class<?> expectedClass) {
        return map.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(expectedClass)).map(Map.Entry::getValue).findAny();
    }

    @Override
    public boolean match(Type expectedType) {
        Validation.notNull(expectedType, "The expected type to match cannot be null.", new Object[0]);
        return TypeMatcherDispatcher.getFactory(this.currentType.getClass(), expectedType.getClass()).map(factory -> factory.create(this.currentType, this.context)).filter(matcher -> matcher.match(expectedType)).isPresent();
    }

    static {
        Arrays.asList(ClassMatcher.class, ClassParameterizedTypeMatcher.class, ParameterizedTypeClassMatcher.class, ParameterizedTypeMatcher.class, TypeVariableTypeMatcher.class).forEach(TypeMatcherDispatcher::addFactory);
    }
}

