/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.Equalizer;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <E extends Comparable<E>> int binarySearch(List<E> list, E key) {
        return CollectionUtils.binarySearch(list, key, Function.identity(), ObjectUtils::compare);
    }

    public static <E, K extends Comparable<K>> int binarySearch(List<E> list, K key, Function<E, K> mapper) {
        return CollectionUtils.binarySearch(list, key, mapper, ObjectUtils::compare);
    }

    public static <E, K extends Comparable<K>> int binarySearch(List<E> list, K key, Function<E, K> mapper, Comparator<K> comparator) {
        Validation.notNull(list, "The list to binary search cannot be null.", new Object[0]);
        Validation.notNull(mapper, "The mapper to map element cannot be null.", new Object[0]);
        Validation.notNull(comparator, "The comparator to compare elements cannot be null.", new Object[0]);
        if (list.isEmpty()) {
            return -1;
        }
        int compareResult = comparator.compare(mapper.apply(list.get(0)), key);
        if (compareResult > 0) {
            return -1;
        }
        if (compareResult == 0) {
            return 0;
        }
        compareResult = comparator.compare(mapper.apply(list.get(list.size() - 1)), key);
        if (compareResult < 0) {
            return -1 - list.size();
        }
        if (compareResult == 0) {
            return list.size() - 1;
        }
        return CollectionUtils.binarySearch0(list, key, mapper, comparator);
    }

    private static <E, K> int binarySearch0(List<E> list, K key, Function<E, K> mapper, Comparator<K> comparator) {
        int left = 0;
        int right = list.size() - 1;
        while (left <= right) {
            int mid = left + right >>> 1;
            int compareResult = comparator.compare(mapper.apply(list.get(mid)), key);
            if (compareResult < 0) {
                left = mid + 1;
                continue;
            }
            if (compareResult > 0) {
                right = mid - 1;
                continue;
            }
            return mid;
        }
        return -(left + 1);
    }

    public static <K1, V1, K2, V2> Map<K2, V2> cast(Map<K1, V1> map, Function<K1, K2> keyMapper, Function<V1, V2> valueMapper) {
        Validation.notNull(keyMapper, "The mapper to cast keys of map cannot be null.", new Object[0]);
        Validation.notNull(valueMapper, "The mapper to cast values of map cannot be null.", new Object[0]);
        if (map == null) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().collect(Collectors.toMap((? super T entry) -> keyMapper.apply(entry.getKey()), (? super T entry) -> valueMapper.apply(entry.getValue())));
    }

    @SafeVarargs
    public static <T> List<T> connect(List<T> ... lists) {
        if (ArrayUtils.isEmpty(lists)) {
            return Collections.emptyList();
        }
        return Arrays.stream(lists).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static <E> Set<E> difference(Collection<E> include, Collection<E> exclude) {
        Validation.notNull(include, "The collection to include cannot be null.", new Object[0]);
        HashSet<E> set = new HashSet<E>(include);
        if (exclude != null) {
            set.removeAll(exclude);
        }
        return set;
    }

    public static <E> boolean equals(Iterable<E> first, Iterable<E> second) {
        return CollectionUtils.equals(first, second, null);
    }

    public static <E> boolean equals(Iterable<E> first, Iterable<E> second, Equalizer<E> equalizer) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        Equalizer<Object> actualEqualizer = ObjectUtils.nullIf(equalizer, Objects::equals);
        Iterator<E> firstIterator = first.iterator();
        Iterator<E> secondIterator = second.iterator();
        while (firstIterator.hasNext()) {
            if (!secondIterator.hasNext()) {
                return false;
            }
            if (actualEqualizer.equals(firstIterator.next(), secondIterator.next())) continue;
            return false;
        }
        return !secondIterator.hasNext();
    }

    public static <E> Set<E> intersect(Collection<E> first, Collection<E> second) {
        Validation.notNull(first, "The collection to intersect cannot be null.", new Object[0]);
        HashSet<E> set = new HashSet<E>(first);
        if (second != null) {
            set.retainAll(second);
        }
        return set;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> Iterator<T> iterator(Iterable<T> iterable) {
        return ObjectUtils.mapIfNotNull(iterable, Iterable::iterator);
    }

    public static <E, R> R mapFirst(Iterable<E> iterable, Function<E, R> mapper) {
        return CollectionUtils.mapFirst(iterable, mapper, null);
    }

    public static <E, R> R mapFirst(Iterable<E> iterable, Function<E, R> mapper, R defaultValue) {
        Validation.notNull(mapper, "The mapper to map element to result cannot be null.", new Object[0]);
        if (iterable != null) {
            for (E element : iterable) {
                R result = mapper.apply(element);
                if (result == null) continue;
                return result;
            }
        }
        return defaultValue;
    }

    public static <E> List<List<E>> split(Collection<E> collection, int partitionLength) {
        return CollectionUtils.split(collection, partitionLength, ArrayList::new);
    }

    public static <E, V extends Collection<E>> List<V> split(Collection<E> collection, int partitionLength, Supplier<V> collectionSupplier) {
        Validation.notNull(collectionSupplier, "The collectionSupplier cannot be null.", new Object[0]);
        Validation.greaterThan(partitionLength, 0, () -> new IllegalArgumentException(StringUtils.format("The partition length must great than 0.", new Object[0])));
        if (CollectionUtils.isEmpty(collection)) {
            return new ArrayList();
        }
        ArrayList<Collection> res = new ArrayList<Collection>();
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Collection newCollection = (Collection)collectionSupplier.get();
            for (int i = 0; i < partitionLength && iterator.hasNext(); ++i) {
                E element = iterator.next();
                newCollection.add(element);
            }
            res.add(newCollection);
        }
        return res;
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> clazz) {
        Validation.notNull(collection, "The collection to convert to array cannot be null.", new Object[0]);
        Validation.notNull(clazz, "Class of list elements cannot be null.", new Object[0]);
        Object[] array = (Object[])Array.newInstance(clazz, 0);
        return collection.toArray(array);
    }

    public static <K, V> Map<K, V> toMap(Collection<V> collection, Function<V, K> keyMapper) {
        Validation.notNull(collection, "The collection to convert to map cannot be null.", new Object[0]);
        Validation.notNull(keyMapper, "The mapper to generate map keys cannot be null.", new Object[0]);
        return collection.stream().collect(Collectors.toMap(keyMapper, (? super T item) -> item));
    }

    public static <K, V, E extends RuntimeException> Map<K, V> toMap(Collection<V> collection, Function<V, K> keyMapper, BiFunction<V, V, E> exceptionSupplier) {
        Validation.notNull(collection, "The collection to convert to map cannot be null.", new Object[0]);
        Validation.notNull(keyMapper, "The mapper to generate map keys cannot be null.", new Object[0]);
        Validation.notNull(exceptionSupplier, "The supplier to handle duplicated keys cannot be null.", new Object[0]);
        return collection.stream().collect(Collectors.toMap(keyMapper, (? super T item) -> item, (v1, v2) -> {
            throw (RuntimeException)exceptionSupplier.apply(v1, v2);
        }));
    }

    public static <T> String toString(Iterable<T> iterable) {
        if (iterable == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        Iterator<T> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            builder.append(ObjectUtils.toString(iterator.next()));
            while (iterator.hasNext()) {
                builder.append(", ").append(ObjectUtils.toString(iterator.next()));
            }
        }
        builder.append(']');
        return builder.toString();
    }

    public static <E> Set<E> union(Collection<E> first, Collection<E> second) {
        Validation.notNull(first, "The collection to union cannot be null.", new Object[0]);
        HashSet<E> set = new HashSet<E>(first);
        if (second != null) {
            set.addAll(second);
        }
        return set;
    }
}

