/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;

public class LazyLoader<T>
implements Supplier<T> {
    private final Supplier<T> factory;
    private final Lock lock;
    private volatile T instance;

    public LazyLoader(Supplier<T> factory) {
        this.factory = Validation.notNull(factory, "The factory for lazy loader cannot be null.", new Object[0]);
        this.lock = LockUtils.newReentrantLock();
    }

    @Override
    public final T get() {
        if (this.instance != null) {
            return this.instance;
        }
        LockUtils.synchronize(this.lock, () -> {
            if (this.instance == null) {
                this.instance = this.factory.get();
            }
        });
        return this.instance;
    }
}

