/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.LineSeparator;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.support.AbstractSetDecorator;
import com.huawei.fitframework.core.common.util.support.MappedIterator;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public class PropertiesStringBuilder {
    private final Properties properties = new OrderedProperties();
    private LineSeparator lineSeparator = LineSeparator.LF;

    public PropertiesStringBuilder setProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public PropertiesStringBuilder setLineSeparator(LineSeparator lineSeparator) {
        this.lineSeparator = ObjectUtils.nullIf(lineSeparator, LineSeparator.LF);
        return this;
    }

    public String build() {
        byte[] bytes;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
            this.properties.store(writer, null);
            bytes = out.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to store properties to memory stream.", e);
        }
        String content = new String(bytes, StandardCharsets.UTF_8);
        String[] lines = content.split(System.lineSeparator());
        return Arrays.stream(lines).filter(PropertiesStringBuilder::isRedundant).collect(Collectors.joining(this.lineSeparator.value()));
    }

    private static boolean isRedundant(String line) {
        String trimmed = StringUtils.trimStart(line);
        return !trimmed.startsWith("#");
    }

    private static class OrderedProperties
    extends Properties {
        private final List<Object> keys = new LinkedList<Object>();

        private OrderedProperties() {
        }

        @Override
        public Object put(Object key, Object value) {
            Object previousValue = super.put(key, value);
            if (previousValue != null) {
                this.keys.remove(key);
            }
            this.keys.add(key);
            return previousValue;
        }

        @Override
        @NonNull
        public Set<Map.Entry<Object, Object>> entrySet() {
            return new AbstractSetDecorator<Map.Entry<Object, Object>>(super.entrySet()){

                @Override
                @NonNull
                public Iterator<Map.Entry<Object, Object>> iterator() {
                    return new MappedIterator<Object, Map.Entry>(keys.iterator(), key -> new AbstractMap.SimpleEntry<Object, Object>(key, this.get(key)));
                }
            };
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return new Enumeration<Object>(){
                private int index = 0;

                @Override
                public boolean hasMoreElements() {
                    return this.index < keys.size();
                }

                @Override
                public Object nextElement() {
                    return keys.get(this.index++);
                }
            };
        }
    }
}

