/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.core.common.util.support.PropertyKey;
import com.huawei.fitframework.core.common.util.support.PropertyKeys;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.stream.IntStream;

public class PropertiesUtils {
    private PropertiesUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> mapFrom(File file) {
        Validation.notNull(file, "The properties file cannot be null.", new Object[0]);
        if (!file.exists()) {
            return Collections.emptyMap();
        }
        try (FileInputStream in = new FileInputStream(file);){
            Map<String, Object> map = PropertiesUtils.mapFrom(in);
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException(StringUtils.format("Fail to load configuration from properties. [file={0}]", file.getName()), e);
        }
    }

    public static Map<String, Object> mapFrom(InputStream in) {
        Validation.notNull(in, "The input stream of properties cannot be null.", new Object[0]);
        Properties properties = new Properties();
        try {
            properties.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to load configuration from properties input stream.", e);
        }
        return PropertiesUtils.mapFrom(properties);
    }

    public static Map<String, Object> mapFrom(Properties properties) {
        Validation.notNull(properties, "The properties cannot be null.", new Object[0]);
        TreeMap source = new TreeMap();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String cfr_ignored_0 = (String)source.put(ObjectUtils.cast(key), ObjectUtils.cast(value));
        }));
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (Map.Entry entry : source.entrySet()) {
            PropertyKeys propertyKeys = new PropertyKeys((String)entry.getKey());
            PropertiesUtils.mapFromPropertyKeys(propertyKeys, 0, (String)entry.getValue(), result);
        }
        return result;
    }

    private static void mapFromArrayValue(PropertyKeys keys, int index, String value, SortedMap<String, Object> result) {
        PropertyKey key = keys.get(index);
        List currentValues = (List)result.computeIfAbsent(key.getActualKey(), k -> new ArrayList());
        if (key.getArrayIndex() >= currentValues.size()) {
            int gap = key.getArrayIndex() - currentValues.size() + 1;
            IntStream.range(0, gap).forEach(times -> currentValues.add(new TreeMap()));
        }
        SortedMap actualValue = (SortedMap)currentValues.get(key.getArrayIndex());
        PropertiesUtils.mapFromPropertyKeys(keys, index + 1, value, actualValue);
    }

    private static void mapFromLastArrayValue(PropertyKey key, String value, SortedMap<String, Object> result) {
        List currentValues = (List)result.computeIfAbsent(key.getActualKey(), k -> new ArrayList());
        currentValues.add(value);
    }

    private static void mapFromLastStringValue(PropertyKey key, String value, SortedMap<String, Object> result) {
        result.put(key.getActualKey(), value);
    }

    private static void mapFromObjectValue(PropertyKeys keys, int index, String value, SortedMap<String, Object> result) {
        SortedMap currentValue = (SortedMap)result.computeIfAbsent(keys.get(index).getActualKey(), k -> new TreeMap());
        PropertiesUtils.mapFromPropertyKeys(keys, index + 1, value, currentValue);
    }

    private static void mapFromPropertyKeys(PropertyKeys keys, int index, String value, SortedMap<String, Object> result) {
        PropertyKey key = keys.get(index);
        if (keys.isLast(index)) {
            if (key.isArray()) {
                PropertiesUtils.mapFromLastArrayValue(key, value, result);
            } else {
                PropertiesUtils.mapFromLastStringValue(key, value, result);
            }
        } else if (key.isArray()) {
            PropertiesUtils.mapFromArrayValue(keys, index, value, result);
        } else {
            PropertiesUtils.mapFromObjectValue(keys, index, value, result);
        }
    }
}

