/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.core.common.util.support;

import com.huawei.fitframework.core.common.util.Interval;

public class DefaultInterval<T extends Comparable<T>>
implements Interval<T> {
    private final T minimum;
    private final T maximum;
    private final boolean minimumAllowed;
    private final boolean maximumAllowed;

    public DefaultInterval(T minimum, T maximum, boolean minimumAllowed, boolean maximumAllowed) {
        this.minimum = minimum;
        this.maximum = maximum;
        this.minimumAllowed = minimumAllowed;
        this.maximumAllowed = maximumAllowed;
    }

    @Override
    public T getMinimum() {
        return this.minimum;
    }

    @Override
    public T getMaximum() {
        return this.maximum;
    }

    @Override
    public boolean isMinimumAllowed() {
        return this.minimumAllowed;
    }

    @Override
    public boolean isMaximumAllowed() {
        return this.maximumAllowed;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isMinimumAllowed()) {
            builder.append('[');
        } else {
            builder.append('(');
        }
        builder.append(this.getMinimum()).append(',').append(' ').append(this.getMaximum());
        if (this.isMaximumAllowed()) {
            builder.append(']');
        } else {
            builder.append(')');
        }
        return builder.toString();
    }
}

