/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cdrommount;

import com.huawei.ism.cdrommount.common.ipmitool.IpmiTool;
import com.huawei.ism.cdrommount.hwdiscover.model.HwDiscoverModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetVmmFlagByIpmi {
    private static final Logger log = LoggerFactory.getLogger(GetVmmFlagByIpmi.class);
    private HwDiscoverModel snmpModel = null;

    public GetVmmFlagByIpmi(HwDiscoverModel snmpModel) {
        this.snmpModel = snmpModel;
    }

    public int getVmmFlag() {
        try {
            this.snmpModel.setIpmiParameter("raw 0x30 0x94 0xdb 0x07 0x00 0x20 0x03 0x00 0x01");
            IpmiTool ipmi = new IpmiTool();
            int ret = 3;
            for (int j = 0; j < 5; ++j) {
                String execResult = ipmi.getExecResult(this.snmpModel);
                if (!ipmi.isSuccessFlag()) {
                    this.snmpModel.setMsg(execResult);
                    log.info("{}:get vmm flag failed,times:{},result:{}", new Object[]{this.snmpModel.getIpAddress(), j, execResult});
                }
                log.info("{}:get vmm flag success.", (Object)this.snmpModel.getIpAddress());
                if (execResult.contains("db 07 00 00 01")) {
                    log.info("{}:vmm flag is encryption.", (Object)this.snmpModel.getIpAddress());
                    ret = 2;
                    break;
                }
                if (!execResult.contains("db 07 00 00 00")) continue;
                log.info("{}:vmm flag is not encryption.", (Object)this.snmpModel.getIpAddress());
                ret = 1;
                break;
            }
            return ret;
        }
        catch (Exception var5) {
            log.error("{}:get vmm flag abnormal,message:", (Object)this.snmpModel.getIpAddress(), (Object)var5);
            return 3;
        }
    }
}

