/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cdrommount.common.ipmitool;

import com.huawei.ism.cdrommount.common.GlobalStaticValue;
import com.huawei.ism.cdrommount.common.SystemInfo;
import com.huawei.ism.cdrommount.common.internationalization.CommonEnum;
import com.huawei.ism.cdrommount.common.model.IpmiAndSnmpModel;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpmiTool {
    private static final Logger log = LoggerFactory.getLogger(IpmiTool.class);
    private static String ipmitool = null;
    private static final Object LOCK = new Object();
    private boolean successFlag = false;

    public IpmiTool() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExecResult(IpmiAndSnmpModel snmpModel) throws Exception {
        StringBuilder result = new StringBuilder();
        StringBuilder errorResult = new StringBuilder();
        Process exec = null;
        InputStream inputStream = null;
        InputStream errorStream = null;
        try {
            int len;
            String cmd = String.format("%s -I %s -C 17 -H %s -p %s -U \"%s\" -P \"%s\" %s", ipmitool, snmpModel.getIpmiInterface().name(), snmpModel.getIpAddress(), snmpModel.getIpmiPort(), snmpModel.getUserName().replace("\"", "\\\""), snmpModel.getUserPassword().replace("\"", "\\\""), snmpModel.getIpmiParameter());
            if (SystemInfo.getOSType() == SystemInfo.OsType.LINUX) {
                String[] command = new String[]{"sh", "-c", cmd};
                exec = Runtime.getRuntime().exec(command);
            } else {
                exec = Runtime.getRuntime().exec(cmd);
            }
            inputStream = exec.getInputStream();
            byte[] bytes = new byte[5120];
            while ((len = inputStream.read(bytes)) != -1) {
                result.append(new String(bytes, 0, len, StandardCharsets.UTF_8));
            }
            errorStream = exec.getErrorStream();
            while ((len = errorStream.read(bytes)) != -1) {
                errorResult.append(new String(bytes, 0, len, StandardCharsets.UTF_8));
            }
            int exitValue = exec.waitFor();
            if (exitValue != 0) {
                String string = this.dealExecuteFailedResult(snmpModel, errorResult);
                return string;
            }
            this.successFlag = true;
        }
        finally {
            if (Objects.nonNull(inputStream)) {
                inputStream.close();
            }
            if (Objects.nonNull(errorStream)) {
                errorStream.close();
            }
            if (Objects.nonNull(exec)) {
                exec.destroy();
            }
        }
        return result.toString();
    }

    private String dealExecuteFailedResult(IpmiAndSnmpModel snmpModel, StringBuilder errorResult) throws Exception {
        if (errorResult.toString().contains("Authentication type NONE not supported")) {
            log.error("{} lanplus execute failed.", (Object)snmpModel.getIpAddress());
            snmpModel.setIpmiInterface(IpmiAndSnmpModel.IpmiInterfaceEnum.lan);
            return this.getExecResult(snmpModel);
        }
        if (errorResult.toString().contains("Invalid user name")) {
            return "User name or password error.";
        }
        if (errorResult.toString().contains("Set Session Privilege Level to ADMINISTRATOR failed")) {
            return "User must be an administrator.";
        }
        if (errorResult.toString().contains("Activate Session command failed")) {
            return "Activate Session command failed";
        }
        if (errorResult.toString().contains("Node busy")) {
            return "Node busy, IPMI channel is occupied.";
        }
        if (errorResult.toString().contains("Command not supported in present state")) {
            return "Command not supported in present state";
        }
        log.info("{} ipmi cmd exec failed.Message:{}", (Object)snmpModel.getIpAddress(), (Object)errorResult);
        return "Unable to establish LAN session, please check ipmi configuration and network.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Object object = LOCK;
        synchronized (object) {
            if (ipmitool == null) {
                SystemInfo.OsType osType = SystemInfo.getOSType();
                ipmitool = osType == SystemInfo.OsType.WINDOWS ? GlobalStaticValue.COMMON_BUNDLE.getValue((Object)CommonEnum.CommonResourcesEnum.WINDOWS_IPMI_TOOL) : GlobalStaticValue.COMMON_BUNDLE.getValue((Object)CommonEnum.CommonResourcesEnum.LINUX_IPMI_TOOL);
            }
        }
    }

    public boolean isSuccessFlag() {
        return this.successFlag;
    }
}

