/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cdrommount.common.model;

import com.huawei.ism.cdrommount.common.UmateException;
import com.huawei.ism.tool.obase.utils.StringUtils;

public class IpmiAndSnmpModel {
    private SnmpVersion version = SnmpVersion.V2C;
    private String ipAddress = "";
    private String userName = "root";
    private String userPassword = "";
    private String snmpPort = "161";
    private String transmitType = "udp";
    private AuthenticationProtocol authenticationProtocol = AuthenticationProtocol.MD5;
    private PrivacyProtocol privacyProtocol = PrivacyProtocol.DES;
    private String community = "rwpublic";
    private String oid = "";
    private String ipmiPort = "623";
    private String ipmiParameter = "";
    private IpmiInterfaceEnum ipmiInterface = IpmiInterfaceEnum.lanplus;
    private SnmpSetValueType snmpValueType = SnmpSetValueType.None;
    private String snmpSetValue = "";

    public void setIPAddress(String ipAddress) throws UmateException {
        String ip;
        String string = ip = ipAddress == null ? "" : ipAddress.replace(" ", "");
        if (StringUtils.isNULLStr(ip)) {
            throw new UmateException("ipAddress cannot be empty.");
        }
        if (!StringUtils.allIsVaildIpv4(ip) && !StringUtils.allIsVaildIpv6(ip)) {
            throw new UmateException(ip + ":Invalid ipAddress.");
        }
        this.ipAddress = ip;
    }

    public void setUserName(String userName) {
        String name;
        String string = name = userName == null ? "root" : userName.trim();
        if (!"".equals(name)) {
            this.userName = name;
        }
    }

    public void setUserPassword(String userPassword) throws UmateException {
        String password;
        String string = password = userPassword == null ? "" : userPassword;
        if (!password.matches("^(?![A-Z]*$)(?![a-z]*$)(?![0-9]*$)(?![^a-zA-Z0-9]*$)\\S{8,20}$")) {
            throw new UmateException("Invalid Password.");
        }
        this.userPassword = password;
    }

    public void setIPMIPort(String ipmiPort) throws UmateException {
        String port;
        String string = port = ipmiPort == null ? "" : ipmiPort.trim();
        if (!"".equals(port)) {
            try {
                if (Integer.parseInt(port) > 65535) {
                    throw new UmateException("ipmiPort is greater than 65535.");
                }
            }
            catch (Exception var3) {
                if (port.matches("[0-9]+")) {
                    throw new UmateException("ipmiPort is greater than 65535.");
                }
                throw new UmateException("ipmiPort must be a number.");
            }
            this.ipmiPort = port;
        }
    }

    public SnmpVersion getVersion() {
        return this.version;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public String getSnmpPort() {
        return this.snmpPort;
    }

    public String getTransmitType() {
        return this.transmitType;
    }

    public AuthenticationProtocol getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public PrivacyProtocol getPrivacyProtocol() {
        return this.privacyProtocol;
    }

    public String getCommunity() {
        return this.community;
    }

    public String getOid() {
        return this.oid;
    }

    public String getIpmiPort() {
        return this.ipmiPort;
    }

    public String getIpmiParameter() {
        return this.ipmiParameter;
    }

    public IpmiInterfaceEnum getIpmiInterface() {
        return this.ipmiInterface;
    }

    public SnmpSetValueType getSnmpValueType() {
        return this.snmpValueType;
    }

    public String getSnmpSetValue() {
        return this.snmpSetValue;
    }

    public void setIpmiParameter(String ipmiParameter) {
        this.ipmiParameter = ipmiParameter;
    }

    public void setIpmiInterface(IpmiInterfaceEnum ipmiInterface) {
        this.ipmiInterface = ipmiInterface;
    }

    public static enum SnmpVersion {
        V1,
        V2C,
        V3;

    }

    public static enum AuthenticationProtocol {
        MD5,
        SHA,
        SHA256,
        SHA384,
        SHA512;

    }

    public static enum PrivacyProtocol {
        DES,
        AES,
        AES256;

    }

    public static enum IpmiInterfaceEnum {
        lan,
        lanplus;

    }

    public static enum SnmpSetValueType {
        Integer32,
        Counter32,
        Counter64,
        Gauge32,
        GenericAddress,
        IpAddress,
        OctetString,
        OID,
        Opaque,
        UnsignedInteger32,
        None;

    }
}

