/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cdrommount.model;

import com.huawei.ism.cdrommount.common.ipmitool.IpmiTool;
import com.huawei.ism.cdrommount.hwdiscover.model.HwDiscoverModel;
import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetVmmKeyByIpmi {
    private static final Logger log = LoggerFactory.getLogger(SetVmmKeyByIpmi.class);
    private String secretKey = "";
    private Long verifyId = null;
    private HwDiscoverModel snmpModel = null;

    public SetVmmKeyByIpmi(HwDiscoverModel snmpModel, Long id) {
        this.snmpModel = snmpModel;
        this.verifyId = id;
        if (id == null) {
            try {
                this.secretKey = SetVmmKeyByIpmi.createSecretUserKey();
            }
            catch (NoSuchAlgorithmException e) {
                log.error("create secret user key fail! reason : ", (Throwable)e);
            }
        } else {
            this.secretKey = String.valueOf(this.verifyId);
        }
    }

    private String createVMMSecretCodeKey() {
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 36; ++i) {
            int randomNum = random.nextInt(94) + 32;
            String hexStr = Integer.toHexString(randomNum);
            sb.append(hexStr);
        }
        return sb.toString();
    }

    public static String createSecretUserKey() throws NoSuchAlgorithmException {
        SecureRandom random = SecurityUtils.createSecureRandom().orElseThrow(() -> new NoSuchAlgorithmException("get SecureRandom failed."));
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= 36; ++i) {
            int randomNum = random.nextInt(94) + 32;
            String hexStr = Integer.toHexString(randomNum);
            sb.append("0x").append(hexStr).append(" ");
        }
        return sb.toString();
    }

    public boolean execSNMPCommand() {
        try {
            IpmiTool ipmi = new IpmiTool();
            String key = null;
            key = this.secretKey;
            String ipmiAdjure = null;
            Object result = null;
            for (int i = 0; i < 4; ++i) {
                ipmiAdjure = i < 3 ? SetVmmKeyByIpmi.construcIpmiAdjureForKVMOrVMM("VMM", true, i, key) : SetVmmKeyByIpmi.construcIpmiAdjureForKVMOrVMM("VMM", false, i, key);
                if (!this.executeIpmiCommand(ipmiAdjure, ipmi)) continue;
                return false;
            }
            log.info("{}:Exec ipmi command kvm inspect key.", (Object)this.snmpModel.getIpAddress());
            return true;
        }
        catch (Exception var8) {
            log.error("{}:Exec ipmi command failure", (Object)this.snmpModel.getIpAddress(), (Object)var8);
            return false;
        }
    }

    private boolean executeIpmiCommand(String ipmiAdjure, IpmiTool ipmi) throws Exception {
        boolean flag = false;
        for (int j = 0; j < 5; ++j) {
            this.snmpModel.setIpmiParameter("raw " + ipmiAdjure);
            String result = ipmi.getExecResult(this.snmpModel);
            log.info("{}:IPMI cmd:raw {} ,result:{}", new Object[]{this.snmpModel.getIpAddress(), ipmiAdjure, result});
            if (result != null && result.contains("db 07 00")) {
                flag = true;
                break;
            }
            log.info("{} :Exec ipmi command failed, times:{}", (Object)this.snmpModel.getIpAddress(), (Object)j);
        }
        if (!flag) {
            log.error("{}:Exec ipmi command failed 5 times.", (Object)this.snmpModel.getIpAddress());
            return true;
        }
        return false;
    }

    private static String construcIpmiAdjureForKVMOrVMM(String type, boolean hasNext, int sequenceNo, String key) {
        StringBuilder sb = new StringBuilder();
        String baseCommond = "0x30 0x94 0xdb 0x07 0x00 0x21 0x06 ";
        sb.append(baseCommond);
        if (hasNext) {
            sb.append("0x01 ");
        } else {
            sb.append("0x00 ");
        }
        if (!StringUtils.isNULLStr(SetVmmKeyByIpmi.parseSequenceNoPartOne(sequenceNo))) {
            sb.append(SetVmmKeyByIpmi.parseSequenceNoPartOne(sequenceNo));
        }
        String[] keyArrays = key.split(" ");
        if (sequenceNo == 0) {
            if ("VMM".equals(type)) {
                sb.append("0x01 ");
            }
            if ("KVM".equals(type)) {
                sb.append("0x00 ");
            }
            sb.append("0x24 ");
        }
        sb.append(SetVmmKeyByIpmi.parseSequenceNoPartTwo(sequenceNo, keyArrays));
        return sb.toString();
    }

    private static String parseSequenceNoPartOne(int sequenceNo) {
        switch (sequenceNo) {
            case 0: {
                return "0x00 0x10 ";
            }
            case 1: {
                return "0x10 0x10 ";
            }
            case 2: {
                return "0x20 0x10 ";
            }
            case 3: {
                return "0x30 0x08 ";
            }
        }
        return "";
    }

    private static String parseSequenceNoPartTwo(int sequenceNo, String[] keyArrays) {
        String str = null;
        switch (sequenceNo) {
            case 0: {
                return SetVmmKeyByIpmi.getKeyString(keyArrays, 0, 14);
            }
            case 1: {
                return SetVmmKeyByIpmi.getKeyString(keyArrays, 14, 30);
            }
            case 2: {
                str = SetVmmKeyByIpmi.getKeyString(keyArrays, 30, 36);
                str = str + "0 0 0 0 0 0 0 0 0 0";
                return str;
            }
            case 3: {
                str = "0 0 0 0 0 0 0 0";
                return str;
            }
        }
        return "";
    }

    private static String getKeyString(String[] keyArrays, int startIndex, int endIndex) {
        String[] partKeyArrays;
        StringBuilder sb = new StringBuilder();
        String[] var5 = partKeyArrays = Arrays.copyOfRange(keyArrays, startIndex, endIndex);
        int var6 = partKeyArrays.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            String partKeyArray = var5[var7];
            sb.append(partKeyArray);
            sb.append(" ");
        }
        return sb.toString();
    }

    public static byte[] convertSecretKeyToBytes(String secretKey, int length) {
        String tmpHexstring = null;
        byte[] negotiatePass = new byte[length];
        for (int i = 0; i < length; ++i) {
            tmpHexstring = secretKey.substring(i * 2, i * 2 + 2);
            try {
                negotiatePass[i] = (byte)(Integer.parseInt(tmpHexstring, 16) & 0xFF);
                continue;
            }
            catch (NumberFormatException var6) {
                log.error("com.huawei.cdrommount.model.SetVmmKeyByIpmi:Convert secret key to bytes failed.", (Throwable)var6);
            }
        }
        return negotiatePass;
    }

    public String getVmmKey() {
        return this.secretKey;
    }
}

