/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule;

import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.SensitiveThrowableRule;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.rule.TypeFilterRule;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule.SensitiveWordsRule;
import java.util.Arrays;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.NotBlank;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="TypeAndMessageFilterRule", category="Core", elementType="SensitiveThrowableRule", printObject=true)
public class TypeAndMessageFilterRule
implements SensitiveThrowableRule {
    private final TypeFilterRule typeFilterRule;
    private final SensitiveWordsRule[] messageRules;

    @Override
    public boolean isSensitiveThrowable(Throwable throwable) {
        return this.messageRules.length > 0 && this.typeFilterRule.isSensitiveThrowable(throwable);
    }

    @Override
    public String buildMessage(Throwable throwable) {
        String message = throwable.getLocalizedMessage();
        if (Strings.isEmpty((CharSequence)message)) {
            return null;
        }
        for (SensitiveWordsRule rule : this.messageRules) {
            String filteredMessage = rule.filterSensitiveWords(message);
            if (filteredMessage == null) continue;
            return throwable.getClass().getName() + ": " + filteredMessage;
        }
        return null;
    }

    public String toString() {
        return "TypeAndMessageFilterRule{typeFilterRule=" + this.typeFilterRule + ", messageRules=" + Arrays.toString(this.messageRules) + '}';
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private TypeAndMessageFilterRule(TypeFilterRule typeFilterRule, SensitiveWordsRule[] messageRules) {
        this.typeFilterRule = typeFilterRule;
        this.messageRules = messageRules;
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<TypeAndMessageFilterRule> {
        @NotBlank
        @PluginBuilderAttribute(value="types")
        private String types;
        @PluginBuilderAttribute(value="includeSubTypes")
        private boolean includeSubTypes = true;
        @PluginElement(value="SensitiveWordsRule")
        private SensitiveWordsRule[] messageRules;

        public TypeAndMessageFilterRule build() {
            return new TypeAndMessageFilterRule(TypeFilterRule.newBuilder().setTypes(this.types).setIncludeSubTypes(this.includeSubTypes).build(), this.messageRules == null || this.messageRules.length == 0 ? SensitiveWordsRule.EMPTY : this.messageRules);
        }

        public Builder setTypes(String types) {
            this.types = types;
            return this;
        }

        public Builder setIncludeSubTypes(boolean includeSubTypes) {
            this.includeSubTypes = includeSubTypes;
            return this;
        }

        public Builder setMessageRules(SensitiveWordsRule[] messageRules) {
            this.messageRules = messageRules;
            return this;
        }

        public String getTypes() {
            return this.types;
        }

        public boolean isIncludeSubTypes() {
            return this.includeSubTypes;
        }

        public SensitiveWordsRule[] getMessageRules() {
            return this.messageRules;
        }
    }
}

