/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.autotest;

import com.huawei.ism.autotest.AutoProcessConfig;
import com.huawei.ism.autotest.AutoProcessItem;
import com.huawei.ism.autotest.AutoProcessStatus;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.PropertiesManager;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoProcessResult {
    private static final Logger log = LoggerFactory.getLogger(AutoProcessResult.class);
    private static AutoProcessResult instance;
    private HashMap<String, AutoProcessItem> expectResults;
    private HashMap<String, AutoProcessItem> results = new HashMap();
    boolean stepFailure = false;
    private PropertiesManager propertiesManager;
    private static final String PROPERTIES = "config.framework.resource.languages.autotest";
    private static final Locale[] LANGUAGES;

    private AutoProcessResult() {
        this.expectResults = AutoProcessConfig.getInstance().getExpectResults();
        this.propertiesManager = new PropertiesManager(PROPERTIES, LANGUAGES, AutoProcessResult.class.getClassLoader());
    }

    public static synchronized AutoProcessResult getInstance() {
        if (instance == null) {
            instance = new AutoProcessResult();
        }
        return instance;
    }

    private String getResultFilePath() {
        StringBuffer pathBuffer = new StringBuffer(ApplicationContext.getInstance().getWorkPath());
        pathBuffer.append(File.separator);
        pathBuffer.append("temp");
        pathBuffer.append(File.separator);
        pathBuffer.append("AutoProcessResult.txt");
        return pathBuffer.toString();
    }

    private void write(File file, String content) {
        try (FileOutputStream output = new FileOutputStream(file, true);){
            output.write(content.getBytes("UTF-8"));
        }
        catch (Exception e) {
            log.error("write error.", (Throwable)e);
        }
    }

    public void overwrite(String content) {
        File resultFile = new File(FilePathUtils.filterPath(this.getResultFilePath()));
        if (resultFile.exists()) {
            try {
                resultFile.delete();
                resultFile.createNewFile();
            }
            catch (Exception e) {
                log.error("operate file error.", (Throwable)e);
            }
        }
        this.write(resultFile, content);
    }

    public void append(String content) {
        File resultFile = new File(FilePathUtils.filterPath(this.getResultFilePath()));
        if (!resultFile.exists()) {
            try {
                resultFile.createNewFile();
            }
            catch (Exception e) {
                log.error("create file error.", (Throwable)e);
            }
        }
        this.write(resultFile, content);
    }

    public HashMap<String, AutoProcessItem> getResults() {
        return this.results;
    }

    public void setResults(HashMap<String, AutoProcessItem> results) {
        this.results = results;
    }

    public boolean isAutoProcessSuccess() {
        StringBuffer message = new StringBuffer(System.lineSeparator());
        if (this.stepFailure) {
            message.append(this.propertiesManager.getString(Locale.CHINESE, "use.case.failure"));
            return false;
        }
        if (this.expectResults.size() == 0) {
            for (String key : this.results.keySet()) {
                AutoProcessItem result = this.results.get(key);
                if (!result.getResult().equals(AutoProcessStatus.FAILURE.toString())) continue;
                this.append(this.getFailureMessage(result));
                return false;
            }
        } else {
            for (String key : this.expectResults.keySet()) {
                AutoProcessItem result = this.results.get(key);
                AutoProcessItem expectResult = this.expectResults.get(key);
                if (expectResult.equals(result)) continue;
                this.append(this.getUnexpectedMessage(result, expectResult));
                return false;
            }
        }
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "use.case.success"));
        this.append(message.toString());
        return true;
    }

    private String getFailureMessage(AutoProcessItem result) {
        StringBuffer message = new StringBuffer(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "use.case.failure"));
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.id") + ": " + result.getId());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.result") + ": " + result.getResult());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.error.message") + ": " + result.getErrorMessage());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.suggestion") + ": " + result.getSuggestion());
        return message.toString();
    }

    private String getUnexpectedMessage(AutoProcessItem result, AutoProcessItem expectResult) {
        StringBuffer message = new StringBuffer(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "use.case.failure"));
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.id") + ": " + result.getId());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.expect.result") + ": " + expectResult.getResult());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.result") + ": " + result.getResult());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.expect.error.message") + ": " + expectResult.getErrorMessage());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.error.message") + ": " + result.getErrorMessage());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.expect.suggestion") + ": " + expectResult.getSuggestion());
        message.append(System.lineSeparator());
        message.append(this.propertiesManager.getString(Locale.CHINESE, "check.item.suggestion") + ": " + result.getSuggestion());
        return message.toString();
    }

    public void setStepFailure(boolean stepFailure) {
        this.stepFailure = stepFailure;
    }

    static {
        LANGUAGES = new Locale[]{Locale.CHINESE, Locale.ENGLISH};
    }
}

