/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.TLVTag;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class MOUtils {
    public static TableRow<MO, UUID> mo2TableRow(MO mo, Object[] displayKeys) {
        DefaultTableRow<MO, UUID> tableRow = new DefaultTableRow<MO, UUID>(displayKeys.length, mo, mo.getUUID());
        IsmTableCell.NumberCell<Number> property = null;
        TLVTag displayKey = null;
        UIPropertyBuilder builder = null;
        for (int i = 0; i < displayKeys.length; ++i) {
            property = null;
            if (displayKeys[i] instanceof TLVTag) {
                displayKey = (TLVTag)displayKeys[i];
                property = mo.getProperty(displayKey);
                if (property instanceof Number) {
                    property = new IsmTableCell.NumberCell<Number>((Number)((Object)property));
                }
            } else if (displayKeys[i] instanceof UIPropertyBuilder) {
                builder = (UIPropertyBuilder)displayKeys[i];
                property = builder.moValue2TableCell(mo);
            }
            if (property == null || "".equals(property)) {
                tableRow.setValueAt(i, "--");
                continue;
            }
            tableRow.setValueAt(i, property);
        }
        return tableRow;
    }

    public static List<TableRow> mo2TableRow(Collection<MO> mos, Object[] displayKeys) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>(mos.size());
        for (MO mo : mos) {
            rows.add(MOUtils.mo2TableRow(mo, displayKeys));
        }
        return rows;
    }

    public static List<Pair<JLabel, JComponent>> mo2UIPair(MO mo, UIPropertyBuilder[] displayPropertys) {
        ArrayList<Pair<JLabel, JComponent>> pairList = new ArrayList<Pair<JLabel, JComponent>>(displayPropertys.length);
        JLabel key = null;
        JComponent value = null;
        Pair<JLabel, JComponent> pair = null;
        for (UIPropertyBuilder displayProperty : displayPropertys) {
            key = displayProperty.moKey2JLabel(mo);
            value = displayProperty.moValue2JComponent(mo);
            pair = new Pair<JLabel, JComponent>(key, value);
            pairList.add(pair);
        }
        return pairList;
    }

    public static Map<UUID, MO> toMOMap(List<MO> mappedluns) {
        HashMap<UUID, MO> map = new HashMap<UUID, MO>(0);
        for (MO mo : mappedluns) {
            map.put(mo.getUUID(), mo);
        }
        return map;
    }

    public static class DefaultUIPropertyBuilder
    implements UIPropertyBuilder {
        @Override
        public JLabel moKey2JLabel(MO mo) {
            return null;
        }

        @Override
        public JComponent moValue2JComponent(MO mo) {
            return null;
        }

        @Override
        public IsmTableCell moValue2TableCell(MO mo) {
            return null;
        }
    }

    public static interface UIPropertyBuilder {
        public JLabel moKey2JLabel(MO var1);

        public IsmTableCell moValue2TableCell(MO var1);

        public JComponent moValue2JComponent(MO var1);
    }
}

