/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.bean;

import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.resourcemanager.ResourceManager;

public enum ProductModelType {
    V1500(0, "V1500"),
    OSP_V1800(1, "V1800"),
    OSP_S2100(2, "S2100"),
    OSP_S2300(3, "S2300"),
    OSP_S5100(4, "S5100"),
    OSP_S5300(5, "S5300"),
    OSP_S5500(6, "S5500"),
    OSP_S5600(7, "S5600"),
    VIS(8, "VIS6000"),
    OSP_S2600(9, "S2600"),
    OSP_S6800E(10, "S6800E"),
    OSP_V1500N(11, "V1500N"),
    OSP_S2300E(12, "S2300E"),
    OSP_COMMON(13, "OSP_COMMON"),
    N8000(15, "N8000"),
    S6900(16, "S6900"),
    S3900(17, "S3900"),
    S2900(42, "S2900"),
    S5500T(18, "S5500T"),
    S5600T(19, "S5600T"),
    S6800T(20, "S6800T"),
    S6900_M100(21, "S6900-M100"),
    S3900_M200(22, "S3900-M200"),
    S3900_M300(23, "S3900-M300"),
    S5900_M100(24, "S5900-M100"),
    S8100(25, "S8100"),
    S5800T(26, "S5800T"),
    V1600N(27, "V1600N"),
    S5900_M200(28, "S5900-M200"),
    N8300(35, "N8000"),
    N8500(36, "N8000"),
    S2600T(30, "S2600T"),
    VIS_800(800, "VIS8200"),
    S8000_I(31, "S8000-I"),
    VIS_801(801, "VIS8400"),
    VIS_802(802, "VIS8600"),
    VIS_803(803, "VIS8800"),
    C3(100, "C3"),
    DORADO_2100(60, "Dorado2100"),
    DORADO_2100_G_2(44, "Dorado2100 G2"),
    VIS6000T(45, "VIS6000T"),
    DORADO_5100(32, "Dorado5100"),
    S2200T(43, "S2200T"),
    HVS_85T(46, "HVS_85T"),
    HVS_88T(47, "HVS_88T"),
    HVS_18800F(56, "18800F"),
    HVS_18500F_V3(89, "18500F_V3"),
    HVS_18800F_V3(90, "18800F_V3"),
    HVS_18500F_V5(104, "18500F_V5"),
    HVS_18800F_V5(106, "18800F_V5"),
    HVS_18500(57, "18500"),
    HVS_18800(58, "18800"),
    HVS_18500_V3(72, "HVS_18500_V3"),
    HVS_18800_V3(73, "HVS_18800_V3"),
    HVS_18500_V5(103, "HVS_18500_V5"),
    HVS_18800_V5(105, "HVS_18800_V5"),
    UNKNOW(-1, "UNKNOW");

    private String name;
    private int value;

    private ProductModelType(int value, String nameIn) {
        this.value = value;
        this.name = nameIn;
    }

    public static ProductModelType getProductModel(int productModelValue) {
        ProductModelType[] types;
        for (ProductModelType productModelType : types = ProductModelType.values()) {
            if (productModelType.getValue() != productModelValue) continue;
            return productModelType;
        }
        return UNKNOW;
    }

    public static ProductModelType getProductModel(String productModelValue) {
        ProductModelType[] types;
        for (ProductModelType productModelType : types = ProductModelType.values()) {
            if (!productModelType.name.equalsIgnoreCase(productModelValue)) continue;
            return productModelType;
        }
        return UNKNOW;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public DeviceType getDeviceType() {
        switch (this) {
            case V1500: 
            case OSP_V1800: 
            case OSP_S2100: 
            case OSP_S2300: 
            case OSP_V1500N: 
            case OSP_S2300E: {
                return DeviceType.S2300;
            }
            case OSP_S5100: 
            case OSP_S5300: 
            case OSP_S5500: 
            case OSP_S5600: 
            case OSP_S6800E: {
                return DeviceType.S5000;
            }
            case OSP_S2600: 
            case V1600N: {
                return DeviceType.S2600;
            }
            case VIS_800: 
            case VIS_801: 
            case VIS_802: 
            case VIS_803: 
            case VIS6000T: 
            case VIS: {
                return DeviceType.VIS;
            }
            case S8100: {
                return DeviceType.S8000;
            }
            case N8000: 
            case N8300: 
            case N8500: {
                return DeviceType.N8000;
            }
        }
        return this.getDeviceType2nd();
    }

    private DeviceType getDeviceType2nd() {
        switch (this) {
            case S8000_I: 
            case S2900: 
            case S3900: 
            case S6900: 
            case S5500T: 
            case S5600T: 
            case S5800T: 
            case S6800T: 
            case S6900_M100: 
            case S3900_M200: 
            case S3900_M300: 
            case S5900_M100: 
            case S5900_M200: 
            case S2600T: 
            case S2200T: {
                return DeviceType.NEX;
            }
            case C3: 
            case HVS_85T: 
            case HVS_88T: 
            case HVS_18500: 
            case HVS_18800: 
            case HVS_18500_V3: 
            case HVS_18800_V3: 
            case HVS_18500_V5: 
            case HVS_18800_V5: 
            case HVS_18800F: 
            case HVS_18500F_V3: 
            case HVS_18800F_V3: 
            case HVS_18500F_V5: 
            case HVS_18800F_V5: {
                return DeviceType.C3;
            }
            case DORADO_2100: 
            case DORADO_2100_G_2: 
            case DORADO_5100: {
                return DeviceType.DORADO_2100;
            }
        }
        return DeviceType.OCEAN_STOR;
    }

    public DeviceType getDeviceTypeV2() {
        switch (this) {
            case S5500T: 
            case S5600T: 
            case S5800T: 
            case S6800T: 
            case S2600T: 
            case HVS_85T: 
            case HVS_88T: 
            case HVS_18500: 
            case HVS_18800: 
            case HVS_18500_V3: 
            case HVS_18800_V3: 
            case HVS_18500_V5: 
            case HVS_18800_V5: 
            case HVS_18800F: 
            case HVS_18500F_V3: 
            case HVS_18800F_V3: 
            case HVS_18500F_V5: 
            case HVS_18800F_V5: {
                return DeviceType.C3;
            }
        }
        return DeviceType.OCEAN_STOR;
    }

    public String toString() {
        String des = ResourceManager.getString("ProductModel_" + this.name());
        return des;
    }
}

