/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.entity;

import com.huawei.ism.common.bean.HealthState;
import com.huawei.ism.common.bean.RunningState;
import com.huawei.ism.common.entity.DefaultHealthStateMapHandler;
import com.huawei.ism.common.entity.DefaultRunningStateMapHandler;
import com.huawei.ism.common.entity.IHealthStateMapHandler;
import com.huawei.ism.common.entity.IRunningStateMapHandler;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class State {
    private static final Logger LOGGER = LoggerFactory.getLogger(State.class);
    public static final String CLASS_LUN_POOL = "LunPool";
    public static final String CLASS_HYPER_LUN = "HyperLun";
    public static final String CLASS_HYPER_COPY = "HyperCopy";
    public static final String CLASS_SNAPSHOT = "Snapshot";
    public static final String CLASS_TIME_SNAPSHOT = "TimeSnapshot";
    public static final String CLASS_BASIC_EXPANDED_LUN = "ExpandedLun";
    public static final String CLASS_HYPER_MIRROR = "HyperMirror";
    public static final String CLASS_HYPER_MIRROR_LUN = "HyperMirrorLun";
    public static final String CLASS_HYPER_MIRROR_TARGET_LUN = "HyperMirrorTargetLun";
    public static final String CLASS_HYPER_MIRROR_LINK = "HyperMirrorLink";
    public static final String CLASS_HYPER_MIRROR_REMOTE_ARRAY = "RemoteArray";
    public static final String CLASS_CONSISTENT_GROUP = "ConsistentGroup";
    public static final String CLASS_HYPER_CLONE = "HyperClone";
    public static final String CLASS_HYPER_CLONE_TARGET_LUN = "HyperCloneTargetLun";
    private static final long serialVersionUID = 1L;
    private static State instance = new State();
    private Map<String, IHealthStateMapHandler> healthStateMapHandlers = new HashMap<String, IHealthStateMapHandler>(0);
    private Map<String, IRunningStateMapHandler> runningStateMapHandlers = new HashMap<String, IRunningStateMapHandler>(0);

    private State() {
    }

    public static State getInstance() {
        return instance;
    }

    public void registerHealthStateMapHandler(String componentType, IHealthStateMapHandler handler) {
        this.healthStateMapHandlers.put(componentType, handler);
    }

    public IHealthStateMapHandler getHealthStateMapHandler(String componentType) {
        return this.healthStateMapHandlers.get(componentType);
    }

    public HealthState getHealthState(String componentType, int value) {
        return this.getHealthState(componentType, "" + value);
    }

    public HealthState getHealthState(String componentType, String value) {
        HealthState state = null;
        try {
            IHealthStateMapHandler handler = this.getHealthStateMapHandler(componentType);
            state = handler.getHealthState(value);
        }
        catch (RuntimeException e) {
            LOGGER.warn("use ILLEGAL because can't find HealthState of:\ncomponentName = " + componentType + "\nvalue = " + value);
        }
        if (state == null) {
            state = HealthState.ILLEGAL;
        }
        return state;
    }

    public void registerRunningStateMapHandler(String componentType, IRunningStateMapHandler handler) {
        this.runningStateMapHandlers.put(componentType, handler);
    }

    public IRunningStateMapHandler getRunningStateMapHandler(String componentType) {
        return this.runningStateMapHandlers.get(componentType);
    }

    public RunningState getRunningState(String componentType, int value) {
        return this.getRunningState(componentType, "" + value);
    }

    public RunningState getRunningState(String componentType, String value) {
        RunningState state = null;
        try {
            IRunningStateMapHandler handler = this.getRunningStateMapHandler(componentType);
            state = handler.getRunningState(value);
        }
        catch (RuntimeException e) {
            LOGGER.warn("use ILLEGAL because can't find RunningState of:\ncomponentName = " + componentType + "\nvalue = " + value);
        }
        if (state == null) {
            state = RunningState.ILLEGAL;
        }
        return state;
    }

    public static String getString(String mapKey) {
        try {
            return ResourceManager.getString(mapKey);
        }
        catch (MissingResourceException e) {
            LOGGER.warn("can't find State description of {} ", (Object)mapKey);
            return "--";
        }
    }

    public static void init() {
        State.initHealthStateMap();
        State.initRunningStateMap();
        State.initAkiHealthStateMap();
        State.initAkiRunningStateMap();
        State.initRSSHealthStateMap();
        State.initRSSRunningStateMap();
    }

    static void initHealthStateMap() {
        DefaultHealthStateMapHandler handler = new DefaultHealthStateMapHandler();
        State state = State.getInstance();
        State.registerHealthStateHandlersPart1(handler, state);
        handler = new DefaultHealthStateMapHandler();
        State.registerHealthStateHandlersPart2(handler, state);
        handler = new DefaultHealthStateMapHandler();
        State.registerHealthStateHandlersPart3(handler, state);
        handler = new DefaultHealthStateMapHandler();
        State.registerHealthStateHandlersPart4(handler, state);
    }

    private static void registerHealthStateHandlersPart4(DefaultHealthStateMapHandler handler, State state) {
        handler.putHealthState("0", HealthState.NORMAL);
        handler.putHealthState("1", HealthState.DEGRADE);
        handler.putHealthState("2", HealthState.FAULTED);
        handler.putHealthState("3", HealthState.DEGRADE);
        handler.putHealthState("4", HealthState.DEGRADE);
        state.registerHealthStateMapHandler("Fan", handler);
        DefaultHealthStateMapHandler linkHandler = new DefaultHealthStateMapHandler();
        linkHandler.putHealthState("0", HealthState.NORMAL);
        linkHandler.putHealthState("1", HealthState.DEGRADE);
        linkHandler.putHealthState("2", HealthState.FAULTED);
        state.registerHealthStateMapHandler("Link", linkHandler);
        DefaultHealthStateMapHandler bbuHandler = new DefaultHealthStateMapHandler();
        bbuHandler.putHealthState("0", HealthState.NORMAL);
        bbuHandler.putHealthState("1", HealthState.FAULTED);
        state.registerHealthStateMapHandler("BBU", bbuHandler);
    }

    private static void registerHealthStateHandlersPart3(DefaultHealthStateMapHandler handler, State state) {
        handler.putHealthState("1", HealthState.NORMAL);
        handler.putHealthState("0", HealthState.FAULTED);
        state.registerHealthStateMapHandler("ExpanderModule", handler);
        DefaultHealthStateMapHandler portCardHealthStateHandler = new DefaultHealthStateMapHandler();
        portCardHealthStateHandler.putHealthState("0", HealthState.UNKNOWN);
        portCardHealthStateHandler.putHealthState("1", HealthState.NORMAL);
        state.registerHealthStateMapHandler("PortCard", portCardHealthStateHandler);
        DefaultHealthStateMapHandler portHealthStateHandler = new DefaultHealthStateMapHandler();
        portHealthStateHandler.putHealthState("0", HealthState.UNKNOWN);
        portHealthStateHandler.putHealthState("1", HealthState.NORMAL);
        portHealthStateHandler.putHealthState("2", HealthState.UNKNOWN);
        portHealthStateHandler.putHealthState("3", HealthState.FAULTED);
        state.registerHealthStateMapHandler("Port", portHealthStateHandler);
        DefaultHealthStateMapHandler raidGroupHealthStateHandler = new DefaultHealthStateMapHandler();
        raidGroupHealthStateHandler.putHealthState("1", HealthState.NORMAL);
        raidGroupHealthStateHandler.putHealthState("2", HealthState.FAULTED);
        raidGroupHealthStateHandler.putHealthState("3", HealthState.DEGRADE);
        raidGroupHealthStateHandler.putHealthState("4", HealthState.INITIALIZE);
        raidGroupHealthStateHandler.putHealthState("5", HealthState.DELETING);
        raidGroupHealthStateHandler.putHealthState("6", HealthState.EXPANDING);
        state.registerHealthStateMapHandler("RaidGroup", raidGroupHealthStateHandler);
        DefaultHealthStateMapHandler lunHealthStateHandler = new DefaultHealthStateMapHandler();
        lunHealthStateHandler.putHealthState("1", HealthState.NORMAL);
        lunHealthStateHandler.putHealthState("2", HealthState.FAULTED);
        lunHealthStateHandler.putHealthState("3", HealthState.NORMAL);
        lunHealthStateHandler.putHealthState("4", HealthState.NORMAL);
        lunHealthStateHandler.putHealthState("6", HealthState.UNKNOWN);
        lunHealthStateHandler.putHealthState("8", HealthState.UNKNOWN);
        state.registerHealthStateMapHandler("Lun", lunHealthStateHandler);
    }

    private static void registerHealthStateHandlersPart2(DefaultHealthStateMapHandler handler, State state) {
        handler.putHealthState("0", HealthState.UNKNOWN);
        handler.putHealthState("1", HealthState.NORMAL);
        handler.putHealthState("2", HealthState.FAULTED);
        handler.putHealthState("3", HealthState.UNKNOWN);
        state.registerHealthStateMapHandler("Controller", handler);
        DefaultHealthStateMapHandler diskHealthStateHandler = new DefaultHealthStateMapHandler();
        diskHealthStateHandler.putHealthState("0", HealthState.NORMAL);
        diskHealthStateHandler.putHealthState("3", HealthState.FAULTED);
        diskHealthStateHandler.putHealthState("4", HealthState.UNKNOWN);
        diskHealthStateHandler.putHealthState("5", HealthState.SINGLE_LINK_FAULT);
        diskHealthStateHandler.putHealthState("6", HealthState.UNAUTHENTICATION);
        diskHealthStateHandler.putHealthState("7", HealthState.HIBERNATE);
        diskHealthStateHandler.putHealthState("9", HealthState.WRITE_PROTECTED);
        diskHealthStateHandler.putHealthState("10", HealthState.SEPARATE);
        state.registerHealthStateMapHandler("Drive", diskHealthStateHandler);
        DefaultHealthStateMapHandler powerSupplyHealthStateHandler = new DefaultHealthStateMapHandler();
        powerSupplyHealthStateHandler.putHealthState("0", HealthState.NORMAL);
        powerSupplyHealthStateHandler.putHealthState("1", HealthState.FAULTED);
        powerSupplyHealthStateHandler.putHealthState("2", HealthState.FAULTED);
        powerSupplyHealthStateHandler.putHealthState("3", HealthState.FAULTED);
        powerSupplyHealthStateHandler.putHealthState("4", HealthState.FAULTED);
        powerSupplyHealthStateHandler.putHealthState("5", HealthState.FAULTED);
        powerSupplyHealthStateHandler.putHealthState("6", HealthState.FAULTED);
        state.registerHealthStateMapHandler("PowerSupply", powerSupplyHealthStateHandler);
        DefaultHealthStateMapHandler batteryHealthStateHandler = new DefaultHealthStateMapHandler();
        batteryHealthStateHandler.putHealthState("0", HealthState.NORMAL);
        batteryHealthStateHandler.putHealthState("1", HealthState.FAULTED);
        batteryHealthStateHandler.putHealthState("2", HealthState.UNKNOWN);
        batteryHealthStateHandler.putHealthState("3", HealthState.I2CFAULT);
        batteryHealthStateHandler.putHealthState("4", HealthState.CHECK);
        state.registerHealthStateMapHandler("Battery", batteryHealthStateHandler);
    }

    private static void registerHealthStateHandlersPart1(DefaultHealthStateMapHandler handler, State state) {
        handler.putHealthState("0", HealthState.SYS_STATUS_POWER_ON);
        handler.putHealthState("1", HealthState.SYS_STATUS_POWER_OFF);
        handler.putHealthState("2", HealthState.SYS_STATUS_NORMALMODE);
        handler.putHealthState("3", HealthState.SYS_STATUS_SAFEMODE);
        handler.putHealthState("4", HealthState.SYS_STATUS_UPGRADE_FIRST);
        handler.putHealthState("5", HealthState.SYS_STATUS_UPGRADE_SECOND);
        state.registerHealthStateMapHandler("Array", handler);
        DefaultHealthStateMapHandler rssArrayHandler = new DefaultHealthStateMapHandler();
        rssArrayHandler.putHealthState("0", HealthState.SYS_STATUS_POWER_ON);
        rssArrayHandler.putHealthState("1", HealthState.SYS_STATUS_POWER_OFF);
        rssArrayHandler.putHealthState("2", HealthState.SYS_STATUS_NORMALMODE);
        rssArrayHandler.putHealthState("3", HealthState.SYS_STATUS_SAFEMODE);
        rssArrayHandler.putHealthState("4", HealthState.SYS_STATUS_UPGRADE_FIRST);
        rssArrayHandler.putHealthState("5", HealthState.SYS_STATUS_UPGRADE_SECOND);
        state.registerHealthStateMapHandler("RSSArray", rssArrayHandler);
        DefaultHealthStateMapHandler harddriveChassisHandler = new DefaultHealthStateMapHandler(new String[]{"0", "2", "3", "4"}, new HealthState[]{HealthState.NORMAL, HealthState.UNKNOWN, HealthState.UNKNOWN, HealthState.UNKNOWN});
        state.registerHealthStateMapHandler("HarddriveChassis", harddriveChassisHandler);
        DefaultHealthStateMapHandler controllerChassisHandler = new DefaultHealthStateMapHandler();
        controllerChassisHandler.putHealthState("0", HealthState.NORMAL);
        controllerChassisHandler.putHealthState("2", HealthState.UNKNOWN);
        controllerChassisHandler.putHealthState("3", HealthState.UNKNOWN);
        controllerChassisHandler.putHealthState("4", HealthState.FAULTED);
        state.registerHealthStateMapHandler("ControllerChassis", controllerChassisHandler);
    }

    static void initRunningStateMap() {
        State state = State.getInstance();
        DefaultRunningStateMapHandler handler = new DefaultRunningStateMapHandler();
        State.registerRunningStateHandlersPart1(state, handler);
        handler = new DefaultRunningStateMapHandler();
        State.registerRunningStateHandlersPart2(state, handler);
        handler = new DefaultRunningStateMapHandler();
        State.registerRunningStateHandlersPart3(state, handler);
        handler = new DefaultRunningStateMapHandler();
        State.registerRunningStateHandlersPart4(state, handler);
    }

    private static void registerRunningStateHandlersPart4(State state, DefaultRunningStateMapHandler handler) {
        handler.putRunningState("1", RunningState.ONLINE);
        handler.putRunningState("2", RunningState.OFFLINE);
        handler.putRunningState("3", RunningState.NOTFORMATTED);
        handler.putRunningState("4", RunningState.FORMATING);
        handler.putRunningState("6", RunningState.INITIALIZE);
        handler.putRunningState("8", RunningState.DELETING);
        state.registerRunningStateMapHandler("Lun", handler);
        DefaultRunningStateMapHandler fanHandler = new DefaultRunningStateMapHandler();
        fanHandler.putRunningState("0", RunningState.ONLINE);
        fanHandler.putRunningState("1", RunningState.OFFLINE);
        fanHandler.putRunningState("2", RunningState.OFFLINE);
        fanHandler.putRunningState("3", RunningState.ONLINE);
        fanHandler.putRunningState("4", RunningState.ONLINE);
        state.registerRunningStateMapHandler("Fan", fanHandler);
        DefaultRunningStateMapHandler bbuHandler = new DefaultRunningStateMapHandler();
        bbuHandler.putRunningState("0", RunningState.EXIST);
        bbuHandler.putRunningState("1", RunningState.NOTEXIST);
        state.registerRunningStateMapHandler("BBU", bbuHandler);
    }

    private static void registerRunningStateHandlersPart3(State state, DefaultRunningStateMapHandler handler) {
        handler.putRunningState("0", RunningState.OFFLINE);
        handler.putRunningState("1", RunningState.ONLINE);
        handler.putRunningState("2", RunningState.FAULTED);
        handler.putRunningState("3", RunningState.INACTIVE);
        handler.putRunningState("4", RunningState.POWERON);
        handler.putRunningState("5", RunningState.POWEROFF);
        handler.putRunningState("6", RunningState.POWEROFF_END);
        state.registerRunningStateMapHandler("PortCard", handler);
        DefaultRunningStateMapHandler portHandler = new DefaultRunningStateMapHandler();
        portHandler.putRunningState("0", RunningState.OFFLINE);
        portHandler.putRunningState("1", RunningState.ONLINE);
        portHandler.putRunningState("2", RunningState.FAULTED);
        portHandler.putRunningState("3", RunningState.NOTEXIST);
        state.registerRunningStateMapHandler("Port", portHandler);
        DefaultRunningStateMapHandler raidGroupHandler = new DefaultRunningStateMapHandler();
        raidGroupHandler.putRunningState("1", RunningState.ONLINE);
        raidGroupHandler.putRunningState("2", RunningState.OFFLINE);
        raidGroupHandler.putRunningState("3", RunningState.ONLINE);
        raidGroupHandler.putRunningState("4", RunningState.ONLINE);
        raidGroupHandler.putRunningState("5", RunningState.OFFLINE);
        raidGroupHandler.putRunningState("6", RunningState.ONLINE);
        state.registerRunningStateMapHandler("RaidGroup", raidGroupHandler);
    }

    private static void registerRunningStateHandlersPart2(State state, DefaultRunningStateMapHandler handler) {
        handler.putRunningState("1", RunningState.ONLINE);
        handler.putRunningState("2", RunningState.OFFLINE);
        handler.putRunningState("3", RunningState.RESTRUCTURE);
        handler.putRunningState("4", RunningState.RESTRUCTURECOMPLETE);
        handler.putRunningState("5", RunningState.COPYBACK);
        handler.putRunningState("6", RunningState.FREESPARE);
        handler.putRunningState("7", RunningState.USEDSPARE);
        handler.putRunningState("8", RunningState.SPARECOPY);
        handler.putRunningState("9", RunningState.FAULTED);
        state.registerRunningStateMapHandler("Drive", handler);
        DefaultRunningStateMapHandler powerSupplyHandler = new DefaultRunningStateMapHandler();
        powerSupplyHandler.putRunningState("0", RunningState.ONLINE);
        powerSupplyHandler.putRunningState("1", RunningState.OFFLINE);
        powerSupplyHandler.putRunningState("2", RunningState.EXIST_BUT_NO_INPUT);
        powerSupplyHandler.putRunningState("3", RunningState.OVERVOLTAGE);
        powerSupplyHandler.putRunningState("4", RunningState.LACKVOLTAGE);
        powerSupplyHandler.putRunningState("5", RunningState.DEV_POWER_LOGIC_STATE_ALARM);
        powerSupplyHandler.putRunningState("6", RunningState.I2CFAULT);
        powerSupplyHandler.putRunningState("7", RunningState.STATESWITCHOFF);
        powerSupplyHandler.putRunningState("8", RunningState.FAULTED);
        state.registerRunningStateMapHandler("PowerSupply", powerSupplyHandler);
        DefaultRunningStateMapHandler batteryHandler = new DefaultRunningStateMapHandler();
        batteryHandler.putRunningState("0", RunningState.ONLINE);
        batteryHandler.putRunningState("1", RunningState.OFFLINE);
        batteryHandler.putRunningState("2", RunningState.OFFLINE);
        batteryHandler.putRunningState("3", RunningState.OFFLINE);
        batteryHandler.putRunningState("255", RunningState.BUTT);
        state.registerRunningStateMapHandler("Battery", batteryHandler);
        DefaultRunningStateMapHandler expanderModuleHandler = new DefaultRunningStateMapHandler();
        expanderModuleHandler.putRunningState("1", RunningState.ONLINE);
        expanderModuleHandler.putRunningState("0", RunningState.OFFLINE);
        state.registerRunningStateMapHandler("ExpanderModule", expanderModuleHandler);
    }

    private static void registerRunningStateHandlersPart1(State state, DefaultRunningStateMapHandler handler) {
        handler.putRunningState("0", RunningState.ONLINE);
        handler.putRunningState("1", RunningState.ONLINE);
        handler.putRunningState("2", RunningState.ONLINE);
        handler.putRunningState("3", RunningState.ONLINE);
        handler.putRunningState("4", RunningState.ONLINE);
        handler.putRunningState("5", RunningState.ONLINE);
        state.registerRunningStateMapHandler("Array", handler);
        DefaultRunningStateMapHandler rssArrayHandler = new DefaultRunningStateMapHandler();
        rssArrayHandler.putRunningState("0", RunningState.ONLINE);
        rssArrayHandler.putRunningState("1", RunningState.ONLINE);
        rssArrayHandler.putRunningState("2", RunningState.ONLINE);
        rssArrayHandler.putRunningState("3", RunningState.ONLINE);
        rssArrayHandler.putRunningState("4", RunningState.ONLINE);
        rssArrayHandler.putRunningState("5", RunningState.ONLINE);
        state.registerRunningStateMapHandler("RSSArray", rssArrayHandler);
        DefaultRunningStateMapHandler harddriveChassisHandler = new DefaultRunningStateMapHandler();
        harddriveChassisHandler.putRunningState("0", RunningState.ONLINE);
        harddriveChassisHandler.putRunningState("2", RunningState.OFFLINE);
        harddriveChassisHandler.putRunningState("3", RunningState.OFFLINE);
        harddriveChassisHandler.putRunningState("4", RunningState.OFFLINE);
        harddriveChassisHandler.putRunningState("5", RunningState.FAULTED);
        state.registerRunningStateMapHandler("HarddriveChassis", harddriveChassisHandler);
        DefaultRunningStateMapHandler controllerChassisHandler = new DefaultRunningStateMapHandler();
        controllerChassisHandler.putRunningState("0", RunningState.ONLINE);
        controllerChassisHandler.putRunningState("2", RunningState.OFFLINE);
        controllerChassisHandler.putRunningState("3", RunningState.OFFLINE);
        controllerChassisHandler.putRunningState("4", RunningState.OFFLINE);
        controllerChassisHandler.putRunningState("5", RunningState.FAULTED);
        state.registerRunningStateMapHandler("ControllerChassis", controllerChassisHandler);
        DefaultRunningStateMapHandler controllerHandler = new DefaultRunningStateMapHandler();
        controllerHandler.putRunningState("0", RunningState.OFFLINE);
        controllerHandler.putRunningState("1", RunningState.ONLINE);
        controllerHandler.putRunningState("2", RunningState.OFFLINE);
        controllerHandler.putRunningState("3", RunningState.OFFLINE);
        state.registerRunningStateMapHandler("Controller", controllerHandler);
    }

    private static void initAkiHealthStateMap() {
        State state = State.getInstance();
        DefaultHealthStateMapHandler handler = new DefaultHealthStateMapHandler();
        handler.putHealthState("0", HealthState.NORMAL);
        handler.putHealthState("1", HealthState.INPUT_OVER_VOLT);
        handler.putHealthState("2", HealthState.INPUT_UNDER_VOLT);
        handler.putHealthState("3", HealthState.POWER_OUTAGE);
        handler.putHealthState("4", HealthState.UPS_OVER_TEMP);
        handler.putHealthState("5", HealthState.UPS_OVER_CURRENT);
        handler.putHealthState("6", HealthState.OUTPUT_SHORT_CIRCUIT);
        handler.putHealthState("7", HealthState.OUTPUT_OVER_VOLT);
        handler.putHealthState("8", HealthState.CHARGER_FAULT);
        handler.putHealthState("9", HealthState.I2CFAULT);
        handler.putHealthState("10", HealthState.BATTERY_FAULT);
        handler.putHealthState("11", HealthState.BATTERY_OVER_VOLT_PROTECT);
        handler.putHealthState("12", HealthState.BATTERY_UNDER_VOLT_PROTECT);
        handler.putHealthState("13", HealthState.NOT_ENOUGH_TO_WRITE);
        handler.putHealthState("14", HealthState.BATTERY_OVERDUE_ALARM);
        state.registerHealthStateMapHandler("AkiUps", handler);
    }

    private static void initAkiRunningStateMap() {
        DefaultRunningStateMapHandler handler = new DefaultRunningStateMapHandler();
        handler.putRunningState("0", RunningState.ONLINE);
        handler.putRunningState("1", RunningState.OFFLINE);
        handler.putRunningState("2", RunningState.FAULTED);
        State.getInstance().registerRunningStateMapHandler("AkiUps", handler);
    }

    private static void initRSSHealthStateMap() {
        DefaultHealthStateMapHandler handler = new DefaultHealthStateMapHandler();
        State.registerRSSHealthStateHandlersPart1(handler);
        handler = new DefaultHealthStateMapHandler();
        State.registerRSSHealthStateHandlersPart2(handler);
    }

    private static void registerRSSHealthStateHandlersPart2(DefaultHealthStateMapHandler handler) {
        handler.putHealthState("1", HealthState.NORMAL);
        handler.putHealthState("2", HealthState.FAULTED);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_MIRROR_LUN, handler);
        DefaultHealthStateMapHandler hyperMirrorTargetLunHandler = new DefaultHealthStateMapHandler();
        hyperMirrorTargetLunHandler.putHealthState("1", HealthState.NORMAL);
        hyperMirrorTargetLunHandler.putHealthState("2", HealthState.FAULTED);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_MIRROR_TARGET_LUN, hyperMirrorTargetLunHandler);
        DefaultHealthStateMapHandler hyperMirrorLinkHandler = new DefaultHealthStateMapHandler();
        hyperMirrorLinkHandler.putHealthState("0", HealthState.FAULTED);
        hyperMirrorLinkHandler.putHealthState("1", HealthState.NORMAL);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_MIRROR_LINK, hyperMirrorLinkHandler);
        DefaultHealthStateMapHandler remoteArrayHandler = new DefaultHealthStateMapHandler();
        remoteArrayHandler.putHealthState("1", HealthState.NORMAL);
        remoteArrayHandler.putHealthState("2", HealthState.FAULTED);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_MIRROR_REMOTE_ARRAY, remoteArrayHandler);
        DefaultHealthStateMapHandler consistentGroupHandler = new DefaultHealthStateMapHandler();
        consistentGroupHandler.putHealthState("1", HealthState.NORMAL);
        consistentGroupHandler.putHealthState("2", HealthState.NORMAL);
        consistentGroupHandler.putHealthState("3", HealthState.NORMAL);
        consistentGroupHandler.putHealthState("4", HealthState.NORMAL);
        consistentGroupHandler.putHealthState("5", HealthState.NORMAL);
        consistentGroupHandler.putHealthState("6", HealthState.NORMAL);
        consistentGroupHandler.putHealthState("7", HealthState.NORMAL);
        State.getInstance().registerHealthStateMapHandler(CLASS_CONSISTENT_GROUP, consistentGroupHandler);
        DefaultHealthStateMapHandler hyperCloneHandler = new DefaultHealthStateMapHandler();
        hyperCloneHandler.putHealthState("1", HealthState.NORMAL);
        hyperCloneHandler.putHealthState("2", HealthState.FAULTED);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_CLONE, hyperCloneHandler);
        DefaultHealthStateMapHandler hyperCloneTargetLunHandler = new DefaultHealthStateMapHandler();
        hyperCloneTargetLunHandler.putHealthState("1", HealthState.NORMAL);
        hyperCloneTargetLunHandler.putHealthState("2", HealthState.FAULTED);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_CLONE_TARGET_LUN, hyperCloneTargetLunHandler);
    }

    private static void registerRSSHealthStateHandlersPart1(DefaultHealthStateMapHandler handler) {
        handler.putHealthState("1", HealthState.NORMAL);
        handler.putHealthState("2", HealthState.FAULTED);
        handler.putHealthState("3", HealthState.NORMAL);
        handler.putHealthState("4", HealthState.NORMAL);
        State.getInstance().registerHealthStateMapHandler(CLASS_BASIC_EXPANDED_LUN, handler);
        DefaultHealthStateMapHandler snapshotHandler = new DefaultHealthStateMapHandler();
        snapshotHandler.putHealthState("1", HealthState.NORMAL);
        snapshotHandler.putHealthState("2", HealthState.FAULTED);
        State.getInstance().registerHealthStateMapHandler(CLASS_SNAPSHOT, snapshotHandler);
        DefaultHealthStateMapHandler timeSnapshotHandler = new DefaultHealthStateMapHandler();
        timeSnapshotHandler.putHealthState("1", HealthState.NORMAL);
        timeSnapshotHandler.putHealthState("2", HealthState.NORMAL);
        timeSnapshotHandler.putHealthState("3", HealthState.FAULTED);
        State.getInstance().registerHealthStateMapHandler(CLASS_TIME_SNAPSHOT, timeSnapshotHandler);
        DefaultHealthStateMapHandler lunPoolHandler = new DefaultHealthStateMapHandler();
        lunPoolHandler.putHealthState("1", HealthState.NORMAL);
        State.getInstance().registerHealthStateMapHandler(CLASS_LUN_POOL, lunPoolHandler);
        DefaultHealthStateMapHandler hyperCopyHandler = new DefaultHealthStateMapHandler();
        hyperCopyHandler.putHealthState("1", HealthState.NORMAL);
        hyperCopyHandler.putHealthState("2", HealthState.FAULTED);
        hyperCopyHandler.putHealthState("3", HealthState.BUSY);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_COPY, hyperCopyHandler);
        DefaultHealthStateMapHandler hyperLunHandler = new DefaultHealthStateMapHandler();
        hyperLunHandler.putHealthState("1", HealthState.NORMAL);
        hyperLunHandler.putHealthState("2", HealthState.FAULTED);
        hyperLunHandler.putHealthState("3", HealthState.NORMAL);
        hyperLunHandler.putHealthState("4", HealthState.NORMAL);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_LUN, hyperLunHandler);
        DefaultHealthStateMapHandler hyperMirrorHandler = new DefaultHealthStateMapHandler();
        hyperMirrorHandler.putHealthState("1", HealthState.NORMAL);
        hyperMirrorHandler.putHealthState("2", HealthState.FAULTED);
        State.getInstance().registerHealthStateMapHandler(CLASS_HYPER_MIRROR, hyperMirrorHandler);
    }

    private static void initRSSRunningStateMap() {
        DefaultRunningStateMapHandler handler = new DefaultRunningStateMapHandler();
        State.registerRSSRunningStateHandlersPart1(handler);
        handler = new DefaultRunningStateMapHandler();
        State.registerRSSRunningStateHandlersPart2(handler);
    }

    private static void registerRSSRunningStateHandlersPart2(DefaultRunningStateMapHandler handler) {
        handler.putRunningState("1", RunningState.ONLINE);
        handler.putRunningState("2", RunningState.FAULTED);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_MIRROR_LUN, handler);
        DefaultRunningStateMapHandler hyperMirrorTargetLunHandler = new DefaultRunningStateMapHandler();
        hyperMirrorTargetLunHandler.putRunningState("1", RunningState.ONLINE);
        hyperMirrorTargetLunHandler.putRunningState("2", RunningState.FAULTED);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_MIRROR_TARGET_LUN, hyperMirrorTargetLunHandler);
        DefaultRunningStateMapHandler hyperMirrorLinkHandler = new DefaultRunningStateMapHandler();
        hyperMirrorLinkHandler.putRunningState("0", RunningState.FAULTED);
        hyperMirrorLinkHandler.putRunningState("1", RunningState.ONLINE);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_MIRROR_LINK, hyperMirrorLinkHandler);
        DefaultRunningStateMapHandler remoteArrayHandler = new DefaultRunningStateMapHandler();
        remoteArrayHandler.putRunningState("1", RunningState.ONLINE);
        remoteArrayHandler.putRunningState("2", RunningState.FAULTED);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_MIRROR_REMOTE_ARRAY, remoteArrayHandler);
        DefaultRunningStateMapHandler consistentGroupHandler = new DefaultRunningStateMapHandler();
        consistentGroupHandler.putRunningState("1", RunningState.NORMAL);
        consistentGroupHandler.putRunningState("2", RunningState.SYNCHRONIZING);
        consistentGroupHandler.putRunningState("3", RunningState.WAIT_RECOVER);
        consistentGroupHandler.putRunningState("4", RunningState.INTERRUPTED);
        consistentGroupHandler.putRunningState("5", RunningState.SPLITED);
        consistentGroupHandler.putRunningState("6", RunningState.INVALID);
        consistentGroupHandler.putRunningState("7", RunningState.FAULTED);
        State.getInstance().registerRunningStateMapHandler(CLASS_CONSISTENT_GROUP, consistentGroupHandler);
        DefaultRunningStateMapHandler hyperCloneHandler = new DefaultRunningStateMapHandler();
        hyperCloneHandler.putRunningState("1", RunningState.ONLINE);
        hyperCloneHandler.putRunningState("2", RunningState.FAULTED);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_CLONE, hyperCloneHandler);
        DefaultRunningStateMapHandler hyperCloneTargetLunHandler = new DefaultRunningStateMapHandler();
        hyperCloneTargetLunHandler.putRunningState("1", RunningState.ONLINE);
        hyperCloneTargetLunHandler.putRunningState("2", RunningState.FAULTED);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_CLONE_TARGET_LUN, hyperCloneTargetLunHandler);
    }

    private static void registerRSSRunningStateHandlersPart1(DefaultRunningStateMapHandler handler) {
        handler.putRunningState("1", RunningState.ONLINE);
        handler.putRunningState("2", RunningState.OFFLINE);
        handler.putRunningState("3", RunningState.NOTFORMATTED);
        handler.putRunningState("4", RunningState.FORMATING);
        State.getInstance().registerRunningStateMapHandler(CLASS_BASIC_EXPANDED_LUN, handler);
        DefaultRunningStateMapHandler snapshotHandler = new DefaultRunningStateMapHandler();
        snapshotHandler.putRunningState("1", RunningState.SNAPSHOTDISABLE);
        snapshotHandler.putRunningState("2", RunningState.SNAPSHOTACTIVE);
        snapshotHandler.putRunningState("3", RunningState.SNAPSHOTROLLBACK);
        State.getInstance().registerRunningStateMapHandler(CLASS_SNAPSHOT, snapshotHandler);
        DefaultRunningStateMapHandler timeSnapshotHandler = new DefaultRunningStateMapHandler();
        timeSnapshotHandler.putRunningState("1", RunningState.SNAPSHOTACTIVE);
        timeSnapshotHandler.putRunningState("2", RunningState.SNAPSHOTDISABLE);
        timeSnapshotHandler.putRunningState("3", RunningState.SNAPSHOTDISABLE);
        State.getInstance().registerRunningStateMapHandler(CLASS_TIME_SNAPSHOT, timeSnapshotHandler);
        DefaultRunningStateMapHandler lunPoolHandler = new DefaultRunningStateMapHandler();
        lunPoolHandler.putRunningState("1", RunningState.ONLINE);
        State.getInstance().registerRunningStateMapHandler(CLASS_LUN_POOL, lunPoolHandler);
        DefaultRunningStateMapHandler hyperCopyHandler = new DefaultRunningStateMapHandler();
        hyperCopyHandler.putRunningState("1", RunningState.UNSTART);
        hyperCopyHandler.putRunningState("2", RunningState.WARTING);
        hyperCopyHandler.putRunningState("3", RunningState.STOP);
        hyperCopyHandler.putRunningState("4", RunningState.COPYING);
        hyperCopyHandler.putRunningState("5", RunningState.COPYCOMPLETE);
        hyperCopyHandler.putRunningState("6", RunningState.PAUSE);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_COPY, hyperCopyHandler);
        DefaultRunningStateMapHandler hyperLunHandler = new DefaultRunningStateMapHandler();
        hyperLunHandler.putRunningState("1", RunningState.ONLINE);
        hyperLunHandler.putRunningState("2", RunningState.OFFLINE);
        hyperLunHandler.putRunningState("3", RunningState.NOTFORMATTED);
        hyperLunHandler.putRunningState("4", RunningState.FORMATING);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_LUN, hyperLunHandler);
        DefaultRunningStateMapHandler hyperMirrorHandler = new DefaultRunningStateMapHandler();
        hyperMirrorHandler.putRunningState("1", RunningState.ONLINE);
        hyperMirrorHandler.putRunningState("2", RunningState.FAULTED);
        State.getInstance().registerRunningStateMapHandler(CLASS_HYPER_MIRROR, hyperMirrorHandler);
    }

    public static enum BasicTargetLinkState {
        LINKDOWN(2),
        LINKUP(1),
        ILLEGAL(-1);

        private static final long serialVersionUID = -7048089658123457658L;
        private int value;

        private BasicTargetLinkState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BasicTargetLinkState getLinkState(int value) {
            BasicTargetLinkState btls = ILLEGAL;
            for (BasicTargetLinkState state : BasicTargetLinkState.values()) {
                btls = BasicTargetLinkState.getLinkState1(value, btls, state);
            }
            LOGGER.warn("use ILLEGAL because can't find BasicTargetLinkState which value = " + value);
            return btls;
        }

        private static BasicTargetLinkState getLinkState1(int value, BasicTargetLinkState btls, BasicTargetLinkState state) {
            if (state.getValue() == value) {
                return state;
            }
            return btls;
        }

        public String getDescription() {
            String des = State.getString("State." + this.name());
            return des;
        }
    }

    public static enum BooleanState {
        ILLEGAL(-1),
        FALSE(0),
        TRUE(1);

        private int value;
        private String booleanStateType;

        private BooleanState(int value) {
            this.value = value;
        }

        public static BooleanState getBooleanState(int value, String type) {
            BooleanState state = BooleanState.getBooleanState(value);
            state.booleanStateType = type;
            return state;
        }

        public static BooleanState getBooleanState(boolean value) {
            if (value) {
                return TRUE;
            }
            return FALSE;
        }

        public static BooleanState getBooleanState(int value) {
            for (BooleanState state : BooleanState.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            LOGGER.warn("use ILLEGAL because can't find BooleanState which value = " + value);
            return ILLEGAL;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String des = ResourceManager.getString("State.BooleanState." + this.name());
            return des;
        }

        public String toStateDetail() {
            if (ILLEGAL == this) {
                return this.toString();
            }
            String des = ResourceManager.getString("State.BooleanState." + this.booleanStateType + '.' + this.name());
            return des;
        }
    }

    public static enum PowerTemperatureState {
        UNKNOW(-1),
        NORMAL(0),
        HIGH_TEMPERATURE(1);

        private int value;

        private PowerTemperatureState(int value) {
            this.value = value;
        }

        public static PowerTemperatureState getTemperatureState(int value) {
            for (PowerTemperatureState state : PowerTemperatureState.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            LOGGER.warn("use ILLEGAL because can't find WormState which value = " + value);
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String des = ResourceManager.getString("State.PowerTemperatureState." + this.name());
            return des;
        }
    }

    public static enum CpuTemperatureState {
        NORMAL(0),
        LOW_SIDE(1),
        HIGH_SIDE(2),
        BAD_LOWSIDE(3),
        BAD_HIGHSIDE(4),
        UNKNOW(-1);

        private int value;

        private CpuTemperatureState(int value) {
            this.value = value;
        }

        public static CpuTemperatureState getTemperatureState(int value) {
            for (CpuTemperatureState temperatureState : CpuTemperatureState.values()) {
                if (temperatureState.getValue() != value) continue;
                return temperatureState;
            }
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            String des = ResourceManager.getString("Cluster.Cpu.Temperature.State." + this.name(), "--");
            return des;
        }
    }

    public static enum WormState {
        ILLEGAL(-1),
        ReadAndWrite(0),
        ReadOnly(1);

        private int value;

        private WormState(int value) {
            this.value = value;
        }

        public static WormState getWormState(int value) {
            for (WormState state : WormState.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            LOGGER.warn("use ILLEGAL because can't find WormState which value = " + value);
            return ILLEGAL;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String des = ResourceManager.getString("State.WormState." + this.name());
            return des;
        }
    }

    public static enum AkiChargeState {
        NOT_FULL_CHARGE(0),
        FULL_CHARGE(1),
        ILLEGAL(-1);

        private int value;

        private AkiChargeState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AkiChargeState getChargeState(int value) {
            for (AkiChargeState chargeState : AkiChargeState.values()) {
                if (chargeState.getValue() != value) continue;
                return chargeState;
            }
            LOGGER.warn("use ILLEGAL because can't find ChargeState which value = " + value);
            return ILLEGAL;
        }

        public String getDescription() {
            String des = ResourceManager.getString("State." + this.name());
            return des;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum SystemMode {
        SM_SYSTEM_SINGLE_MODE_WITH_FAULT(0),
        SM_SYSTEM_SINGLE_MODE_NORMAL(1),
        SM_SYSTEM_DOUBLE_CONTROL_MODE(2),
        SM_SYSTEM_DOUBLE_CONTROL_WITH_FAULT(3),
        ILLEGAL_MODE(-1);

        private int value;

        private SystemMode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static SystemMode getSystemMode(int value) {
            for (SystemMode mode : SystemMode.values()) {
                if (mode.getValue() != value) continue;
                return mode;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("use ILLEGAL_MODE because can't find SystemMode which value = " + value);
            }
            return ILLEGAL_MODE;
        }

        public String getDescription() {
            String des = State.getString("State." + this.name());
            return des;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum BBUChargeState {
        NOT_FULL_CHARGE(0),
        FULL_CHARGE(1),
        SUFFICIENT(2),
        INSUFFICIENT(3),
        ILLEGAL(-1);

        private int value;

        private BBUChargeState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static BBUChargeState getChargeState(int value) {
            for (BBUChargeState chargeState : BBUChargeState.values()) {
                if (chargeState.getValue() != value) continue;
                return chargeState;
            }
            LOGGER.warn("use ILLEGAL because can't find BBUChargeState which value = " + value);
            return ILLEGAL;
        }

        public String getDescription() {
            String des = State.getString("State." + this.name());
            return des;
        }

        public String toString() {
            return this.name();
        }
    }

    public static enum VersionState {
        UNKNOW(-1),
        ACTIVATION(1),
        INACTIVATION(2),
        ROLLBACK(3),
        VERIFY(4);

        private static final long serialVersionUID = -7048089658654284858L;
        private int value;

        private VersionState(int value) {
            this.value = value;
        }

        public static VersionState getVersionState(int value) {
            for (VersionState state : VersionState.values()) {
                if (value != state.getValue()) continue;
                return state;
            }
            LOGGER.error("VersionState.getVersionState wrong state argument:" + value);
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String des = State.getString("State.VersionState." + this.name());
            return des;
        }
    }

    public static enum LinkState {
        LINKDOWN(0),
        LINKUP(1),
        FAULT(2),
        ILLEGAL(-1);

        private static final long serialVersionUID = -7048089658123457658L;
        private int value;

        private LinkState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LinkState getLinkState(int value) {
            for (LinkState state : LinkState.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            LOGGER.warn("use ILLEGAL because can't find LinkState which value = " + value);
            return ILLEGAL;
        }

        public String getDescription() {
            String des = State.getString("State." + this.name());
            return des;
        }
    }

    public static enum MirrorLinkState {
        LINKDOWN,
        LINKUP,
        ILLEGAL;

        private static final int STATE_LINKDOWN1 = 0;
        private static final int STATE_LINKDOWN2 = 3;
        private static final int STATE_LINKUP = 4;
        private static final long serialVersionUID = -7048089658123457658L;

        public static MirrorLinkState getMirrorLinkState(int value) {
            MirrorLinkState state = ILLEGAL;
            if (value >= 0 && value <= 3) {
                state = LINKDOWN;
            } else if (value == 4) {
                state = LINKUP;
            } else {
                LOGGER.warn("use ILLEGAL because can't find MirrorLinkState which value = " + value);
            }
            return state;
        }

        public String getDescription() {
            String des = State.getString("State." + this.name());
            return des;
        }
    }

    public static class DischargeState
    implements Serializable {
        public static final DischargeState DISCHARGING = new DischargeState("DISCHARGING", 0);
        public static final DischargeState NODISCHARGED = new DischargeState("NODISCHARGED", 1);
        public static final DischargeState ILLEGAL = new DischargeState("ILLEGAL", -1);
        private static final long serialVersionUID = -7048069228976381058L;
        private static Collection<DischargeState> cache = new ArrayList<DischargeState>(0);
        private final String name;
        private final int value;

        protected DischargeState(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }

        public static DischargeState getDischargeState(int value) {
            for (DischargeState dischargeState : cache) {
                if (dischargeState.getValue() != value) continue;
                return dischargeState;
            }
            LOGGER.warn("use ILLEGAL because can't find DischargeState which value = " + value);
            return ILLEGAL;
        }

        public String getDescription() {
            String des = State.getString("State." + this.getName());
            return des;
        }

        static {
            cache.add(DISCHARGING);
            cache.add(NODISCHARGED);
            cache.add(ILLEGAL);
        }
    }

    public static enum ChargeState {
        CHARGE_NOTAVG(0),
        CHARGE_AVG(1),
        CHARGE_INVALID(2),
        ILLEGAL(-1);

        private static final long serialVersionUID = -7048089658946381058L;
        private int value;

        private ChargeState(int value) {
            this.value = value;
        }

        private int getValue() {
            return this.value;
        }

        public static ChargeState getChargeState(int value) {
            for (ChargeState chargeState : ChargeState.values()) {
                if (chargeState.getValue() != value) continue;
                return chargeState;
            }
            LOGGER.warn("use ILLEGAL because can't find ChargeState which value = " + value);
            return ILLEGAL;
        }

        public String getDescription() {
            String des = State.getString("State." + this.name());
            return des;
        }
    }

    public static enum HalfLifeState {
        NORMAL(0),
        HALFLIFE(1),
        UNKNOW(-1);

        private static final long serialVersionUID = -7048089658159654858L;
        private int value;

        private HalfLifeState(int value) {
            this.value = value;
        }

        public static HalfLifeState getHalfLifeState(int value) {
            for (HalfLifeState state : HalfLifeState.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            LOGGER.warn("use ILLEGAL because can't find HalfLifeState which value = " + value);
            return UNKNOW;
        }

        public static HalfLifeState getHalfLifeState(boolean value) {
            if (value) {
                return HALFLIFE;
            }
            return NORMAL;
        }

        public int getValue() {
            return this.value;
        }

        public String getDescription() {
            String des = State.getString("State.HalfLifeState." + this.name());
            return des;
        }
    }
}

