/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.resourcemanager;

import com.huawei.ism.FrameworkCommon;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.util.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LocalResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalResourceManager.class);
    private static LocalResourceManager instance = new LocalResourceManager();
    private File userDataDir = null;
    private File ismRootDir = null;

    private LocalResourceManager() {
        this.initDefaultUserDataDir();
    }

    public static synchronized LocalResourceManager getInstance() {
        return instance;
    }

    public String getUserDataDir() {
        return FilePathUtils.getCanonicalPath(this.userDataDir);
    }

    public String getISMRootDir() {
        String rootPath = ApplicationContext.getInstance().getAppConfig("app.log.path");
        File rootDir = new File(FilePathUtils.filterPath(rootPath));
        StringBuilder sbLogPath = new StringBuilder();
        sbLogPath.append(FilePathUtils.getCanonicalPath(rootDir));
        sbLogPath.append(File.separator);
        sbLogPath.append("log");
        sbLogPath.append(File.separator);
        sbLogPath.append("ismlog");
        return sbLogPath.toString();
    }

    private void initDefaultUserDataDir() {
        String ismRootDirName = "ISM" + File.separator;
        String userDataDirTmp = "";
        if ("Windows".equalsIgnoreCase(LocalResourceManager.getOSName())) {
            String allUserProfile = System.getenv("ALLUSERSPROFILE");
            if (null != allUserProfile) {
                String rootDir = allUserProfile + File.separator + "Application Data";
                userDataDirTmp = rootDir + File.separator + ismRootDirName;
            }
        } else {
            userDataDirTmp = System.getProperty("user.home") + File.separator + ismRootDirName;
            File tempFile = new File(FilePathUtils.filterPath(Utils.fixFotifyPathManipulation(userDataDirTmp)));
            if (!tempFile.exists() && !tempFile.mkdirs()) {
                userDataDirTmp = File.separator + "tmp" + File.separator + ismRootDirName;
            }
        }
        userDataDirTmp = System.getProperty("ISM_DATA_ROOT", userDataDirTmp);
        String path = FrameworkCommon.getInstance().getStrProperty("ism_version") + File.separator + FrameworkCommon.getInstance().getStrProperty("-path", "Default");
        this.ismRootDir = new File(FilePathUtils.filterPath(Utils.fixFotifyPathManipulation(userDataDirTmp)));
        this.userDataDir = new File(this.ismRootDir, path);
        if (!this.userDataDir.exists()) {
            try {
                if (!this.userDataDir.mkdirs()) {
                    LOGGER.error("mkdirs {} failed", (Object)StringUtils.getCleanMessage(this.userDataDir.toString()));
                }
            }
            catch (Exception e) {
                LOGGER.error("mkdirs " + StringUtils.getCleanMessage(this.userDataDir.toString()) + " failed", (Throwable)e);
            }
        }
    }

    private static String getOSName() {
        String osName;
        String osIniName = System.getProperty("os.name");
        String string = osName = osIniName == null ? "Windows" : osIniName.toLowerCase(Locale.US);
        if (osName.contains("sun")) {
            return "Solaris";
        }
        if (osName.contains("windows") || osName.contains("win")) {
            return "Windows";
        }
        return "Linux";
    }

    public BufferedWriter getBufferedWriter(String fileName) throws IOException {
        File file = this.getFile(fileName, true);
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, Charset.defaultCharset());
        BufferedWriter bw = new BufferedWriter(osw);
        return bw;
    }

    public BufferedReader getBufferedReader(String fileName) throws IOException {
        File file = this.getFile(fileName, false);
        if (!file.exists()) {
            return null;
        }
        FileInputStream fos = new FileInputStream(file);
        InputStreamReader osw = new InputStreamReader((InputStream)fos, Charset.defaultCharset());
        BufferedReader br = new BufferedReader(osw);
        return br;
    }

    public File getFile(String fileName, boolean createIfNoExist) throws IOException {
        File file = new File(this.userDataDir + File.separator + fileName);
        if (createIfNoExist && !file.exists()) {
            File parent = file.getParentFile();
            boolean success = true;
            if (!parent.exists()) {
                success = parent.mkdirs();
            }
            if (success) {
                success = file.createNewFile();
            }
            if (!success) {
                throw new IOException("Can't create file \"" + fileName + "\"");
            }
        }
        return file;
    }
}

