/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.connection;

import com.huawei.ism.connection.IConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.util.NetUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SocketPool.class);
    public static final int MSG_MAX_LEN = 0x100000;
    public static final int DEFAULT_TIME_OUT_SECOND = 30;
    private static final String IO_EXCEPTION = "IOException";
    private String deviceID = null;
    private int socketCacheSize = 1;
    private Semaphore available = null;
    private boolean[] used = null;
    private List<String> deviceIPList = Collections.synchronizedList(new ArrayList(2));
    private String masterIP = null;
    private List<Socket> sockets = new ArrayList<Socket>();
    private int port;
    private int protocolType;
    private int retryTimes = 10;
    private int defaultTimeOut;
    private int connectTimeout = 7;
    private int next;
    private int end;
    private final Lock lock = new ReentrantLock();

    public SocketPool(String ip, int port, int protocolType, int socketCacheSize) {
        this.deviceIPList.add(ip);
        this.socketCacheSize = socketCacheSize;
        this.port = port;
        this.protocolType = protocolType;
        this.available = new Semaphore(this.socketCacheSize, true);
        this.used = new boolean[socketCacheSize];
        for (int index = 0; index < socketCacheSize; ++index) {
            this.sockets.add(null);
        }
        this.next = 0;
        this.end = socketCacheSize;
    }

    public SocketPool(String ip, int port, int protocolType, int socketCacheSize, Socket socket) {
        this(ip, port, protocolType, socketCacheSize);
        if (this.sockets.size() > 0) {
            this.sockets.set(0, socket);
        }
    }

    public SocketPool(String ip, int port, int protocolType, int socketCacheSize, int retryTimes) {
        this(ip, port, protocolType, socketCacheSize);
        this.retryTimes = retryTimes;
    }

    public SocketPool(int defaultTimeOut) {
        this.defaultTimeOut = defaultTimeOut;
    }

    public void setConnectTimeout(int connTimeout) {
        this.connectTimeout = connTimeout;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public Socket getSocket() throws InterruptedException {
        this.available.acquire();
        HashMap<String, Object> reason = new HashMap<String, Object>();
        Socket socket = this.getNextAvailableItem(reason);
        if (socket == null) {
            IOException ioe;
            this.available.release();
            Object obj = reason.get(IO_EXCEPTION);
            if (obj != null && obj instanceof IOException && (ioe = (IOException)obj).getMessage().contains("timed out")) {
                throw new IsmException(1073949185L, (Throwable)ioe);
            }
            throw new IsmException(1073949185L, null);
        }
        return socket;
    }

    private boolean isClosed(int i) {
        boolean flag;
        try {
            this.lock.lock();
            flag = this.sockets.get(i) == null || this.sockets.get(i).isClosed() || null == this.sockets.get(i).getRemoteSocketAddress();
        }
        finally {
            this.lock.unlock();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocketByIP(String ip) throws InterruptedException {
        Socket socket = null;
        try {
            int i;
            this.lock.lock();
            if (!this.deviceIPList.contains(ip)) {
                throw new IsmException(1073949185L, null);
            }
            this.available.acquire();
            HashMap<String, Object> reason = new HashMap<String, Object>();
            for (i = 0; i < this.end; ++i) {
                if (this.used[i]) continue;
                if (this.isClosed(i)) {
                    this.sockets.set(i, this.tryConnecting(ip, this.port, this.protocolType, reason));
                    socket = this.sockets.get(i);
                    break;
                }
                InetSocketAddress addr = (InetSocketAddress)this.sockets.get(i).getRemoteSocketAddress();
                if (!addr.getAddress().getHostAddress().equals(ip)) continue;
                socket = this.sockets.get(i);
                break;
            }
            if (socket == null) {
                this.available.release();
                throw new IsmException(1073949185L, null);
            }
            this.used[i] = true;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Set used flag to true: " + i);
            }
        }
        finally {
            this.lock.unlock();
        }
        return socket;
    }

    public boolean releaseSocket(Socket socket) {
        if (this.markAsUnused(socket)) {
            this.available.release();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IConnection.ConnectionState getConnectionState() {
        try {
            this.lock.lock();
            for (Socket socket : this.sockets) {
                if (socket == null || !socket.isConnected()) continue;
                IConnection.ConnectionState connectionState = IConnection.ConnectionState.Connected;
                return connectionState;
            }
        }
        finally {
            this.lock.unlock();
        }
        return IConnection.ConnectionState.Disconnected;
    }

    private int find(int f, int t) {
        for (int i = f; i < t; ++i) {
            if (this.used[i]) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getNextAvailableItem(Map<String, Object> reasonMap) {
        int i = 0;
        try {
            this.lock.lock();
            i = this.find(this.next, this.end);
            if (i == -1) {
                i = this.find(0, this.next);
            }
            if (i == -1 && this.end < this.socketCacheSize) {
                i = this.end++;
            }
            ++this.next;
            if (this.next == this.end) {
                this.next = 0;
            }
            if (i == -1) {
                Socket socket = null;
                return socket;
            }
            if (this.sockets.get(i) != null && this.sockets.get(i).isClosed()) {
                this.sockets.set(i, null);
            }
            if (this.sockets.get(i) == null) {
                this.sockets.set(i, this.buildSocket(reasonMap));
            }
            if (this.sockets.get(i) != null) {
                this.used[i] = true;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Set used flag to true: " + i);
                }
            }
            Socket socket = this.sockets.get(i);
            return socket;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markAsUnused(Socket item) {
        try {
            this.lock.lock();
            for (int i = 0; i < this.socketCacheSize; ++i) {
                if (item != this.sockets.get(i)) continue;
                if (this.used[i]) {
                    this.used[i] = false;
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Set used flag to false: " + i);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    protected void addDeviceIP(String ip) {
        try {
            this.lock.lock();
            if (!this.isNull(ip) && !this.deviceIPList.contains(ip)) {
                this.deviceIPList.add(ip);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isNull(String ip) {
        return null == ip || "".equals(ip) || "--".equals(ip);
    }

    protected void setMasterIP(String ip) {
        try {
            this.lock.lock();
            this.masterIP = InetAddress.getByName(ip).getHostAddress();
        }
        catch (UnknownHostException e) {
            LOGGER.error("", (Throwable)e);
            this.masterIP = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void removeDeviceIP(String ip) {
        try {
            this.lock.lock();
            if (this.deviceIPList.contains(ip)) {
                this.deviceIPList.remove(ip);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void cleanAllIP() {
        try {
            this.lock.lock();
            this.deviceIPList.clear();
            this.masterIP = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<String> getAllIP() {
        ArrayList<String> list;
        try {
            this.lock.lock();
            list = new ArrayList<String>();
            list.addAll(this.deviceIPList);
        }
        finally {
            this.lock.unlock();
        }
        return list;
    }

    private Socket buildSocket(Map<String, Object> reasonMap) {
        Socket socket;
        if (this.masterIP != null && (socket = this.tryConnecting(this.masterIP, this.port, this.protocolType, reasonMap)) != null) {
            return socket;
        }
        String ip = null;
        Socket socket2 = null;
        Iterator<String> iterator = this.deviceIPList.iterator();
        while (iterator.hasNext()) {
            ip = iterator.next();
            socket2 = this.tryConnecting(ip, this.port, this.protocolType, reasonMap);
            if (socket2 == null) continue;
            iterator.remove();
            break;
        }
        if (socket2 != null) {
            this.deviceIPList.add(0, ip);
        }
        return socket2;
    }

    private Socket tryConnecting(String ipAddress, int portIn, int protocolTypeIn, Map<String, Object> reasonMap) {
        Socket socket = null;
        for (int i = 0; i < this.retryTimes; ++i) {
            try {
                socket = NetUtil.connect(ipAddress, portIn, protocolTypeIn, null, this.connectTimeout * 1000);
                if (null == socket) {
                    LOGGER.warn("socket is null.");
                    return null;
                }
                socket.setReceiveBufferSize(0x100000);
                if (this.defaultTimeOut > 0) {
                    socket.setSoTimeout(this.defaultTimeOut * 1000);
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("succeed connect to IP " + ipAddress + " : " + portIn);
                    LOGGER.info("connect socket type:" + (0 == protocolTypeIn ? "COMMON SOCKECT" : "SSL SOCKECT"));
                }
                return socket;
            }
            catch (ClassCastException e) {
                LOGGER.warn("ClassCastException :faild connect to " + ipAddress, (Throwable)e);
                continue;
            }
            catch (Exception e) {
                LOGGER.warn("faild connect to " + ipAddress, (Throwable)e);
                if (null != reasonMap) {
                    reasonMap.put(IO_EXCEPTION, e);
                }
                if (i < this.retryTimes - 1 && this.isReachable(ipAddress)) {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("IP address " + ipAddress + " can reachable. Retry.");
                    continue;
                }
                if (!LOGGER.isInfoEnabled()) break;
                LOGGER.info("IP address " + ipAddress + " can not reachable.");
                break;
            }
        }
        if (null != socket) {
            try {
                socket.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    private boolean isReachable(String ip) {
        try {
            return InetAddress.getByName(ip).isReachable(5000);
        }
        catch (IOException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

