/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.exception;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.ErrorMessageManager;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class IsmException
extends RuntimeException {
    private static final long serialVersionUID = -470502040117597105L;
    private Object operationObject = null;
    private String errorMessage = "";
    private long errorId = -1L;

    public IsmException(String message, Throwable cause) {
        super(cause);
        this.errorMessage = message;
    }

    public IsmException(long errorID, Throwable cause) {
        super(cause);
        this.errorId = errorID;
    }

    public IsmException(long errorID) {
        this(errorID, (Object)null);
    }

    public IsmException(long errorId, Object operationObject) {
        this(errorId, operationObject, null);
    }

    public IsmException(long errorID, Object operationObject, String errorMsg) {
        this.operationObject = operationObject;
        this.errorMessage = errorMsg;
        this.errorId = errorID;
    }

    public IsmException(String errorMsg) {
        super(errorMsg);
        this.errorMessage = errorMsg;
    }

    public IsmException(String errorMsg, long errorID) {
        super(errorMsg);
        this.errorMessage = errorMsg;
        this.errorId = errorID;
    }

    public String getErrorMessage() {
        if (this.errorMessage == null || this.errorMessage.isEmpty()) {
            this.errorMessage = ResourceManager.getString("" + this.getErrorId());
        }
        if (this.errorMessage.equals("--")) {
            this.errorMessage = ErrorMessageManager.getErrorMessage(this.getErrorId());
        }
        if (this.errorMessage.equals("--")) {
            this.errorMessage = "errorCode:" + this.getErrorId();
        }
        return this.errorMessage;
    }

    public Object getOperationObject() {
        return this.operationObject;
    }

    public void setOperationObject(Object operationObject) {
        this.operationObject = operationObject;
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("Operation Object:", this.operationObject).append("Error Code:", this.getErrorId()).append(",Description:", (Object)this.errorMessage).toString();
    }

    public void setErrorMessage(String msg) {
        this.errorMessage = msg;
    }

    public long getErrorId() {
        return this.errorId;
    }

    public String getErrorReason() {
        return ErrorMessageManager.getErrorReason(this.getErrorId());
    }

    public List<String> getSuggestions() {
        return ErrorMessageManager.getErrorSuggestions(this.getErrorId());
    }
}

