/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.model;

import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.TLVMOMsg;
import com.huawei.ism.tlv.TLVTag;
import com.huawei.ism.util.Assert;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MO
implements Serializable,
Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MO.class);
    private static final long serialVersionUID = -4748760937293893420L;
    private volatile UUID parentUUID = null;
    private volatile UUID uuid = null;
    private transient Map<Object, Object> properties = new ConcurrentHashMap<Object, Object>();
    private transient Map<String, String> otherInfo = new ConcurrentHashMap<String, String>();

    protected MO(String deviceID) {
        if (deviceID == null || deviceID.trim().length() < 1) {
            throw new IllegalArgumentException("Device ID must NOT be NULL!");
        }
        this.uuid = new UUID(deviceID, null, null);
    }

    public MO(String deviceID, int moTypeValue, String id) {
        Assert.notNull(deviceID);
        Assert.notNull(id);
        this.uuid = new UUID(deviceID, MOType.getType(moTypeValue), id);
    }

    public MO(String deviceID, MOType moType, String id) {
        Assert.notNull(deviceID);
        Assert.notNull((Object)moType);
        Assert.notNull(id);
        this.uuid = new UUID(deviceID, moType, id);
    }

    public MO(UUID uuid) {
        Assert.notNull(uuid);
        this.uuid = uuid;
    }

    public String getID() {
        return this.uuid.getID();
    }

    public void setID(String id) {
        this.uuid.setID(id);
    }

    public int getMOTypeValue() {
        return this.uuid.getMOTypeValue();
    }

    public MOType getMOType() {
        return this.uuid.getMOType();
    }

    public void setMOType(MOType type) {
        this.uuid.setMOType(type);
    }

    public UUID getParentUUID() {
        return null != this.parentUUID ? this.parentUUID : this.createParentUUID();
    }

    private UUID createParentUUID() {
        UUID currUUID = null;
        Object typeObj = this.properties.get(TLVMOMsg.PARENTTYPE);
        Object idObj = this.properties.get(TLVMOMsg.PARENTID);
        if (idObj != null && typeObj != null) {
            int parentType = Integer.valueOf(typeObj.toString());
            String parentidStr = idObj.toString();
            currUUID = new UUID(this.getDeviceID(), MOType.getType(parentType), parentidStr);
        }
        return currUUID;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public void setUUID(UUID uuidValue) {
        this.uuid = uuidValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MO other = (MO)obj;
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public void setParentUUID(UUID parentUUID) {
        if (null == parentUUID) {
            LOGGER.error("set parentUuId to component error.parentUuId is null");
            return;
        }
        this.parentUUID = parentUUID;
    }

    public Object getProperty(Object key) {
        if (null == key) {
            throw new NullPointerException("arg name can't be null");
        }
        if (this.properties == null || this.properties.isEmpty()) {
            if (!this.otherInfo.isEmpty() && key instanceof TLVTag) {
                String name = ((TLVTag)key).getTagName();
                return this.otherInfo.get(name);
            }
            return null;
        }
        return this.properties.get(key);
    }

    public String getStrProperty(Object key) {
        if (null == key) {
            throw new NullPointerException("arg name can't be null");
        }
        if (this.properties == null || this.properties.isEmpty()) {
            if (!this.otherInfo.isEmpty()) {
                if (key instanceof TLVTag) {
                    String name = ((TLVTag)key).getTagName();
                    return this.otherInfo.get(name);
                }
                if (key instanceof String) {
                    return this.otherInfo.get(key);
                }
            }
            return null;
        }
        Object object = this.properties.get(key);
        if (null != object) {
            return object.toString();
        }
        return null;
    }

    public int getIntProperty(Object key) {
        if (null == key) {
            throw new NullPointerException("arg name can't be null");
        }
        if (this.properties == null || this.properties.isEmpty()) {
            if (!this.otherInfo.isEmpty() && key instanceof TLVTag) {
                String name = ((TLVTag)key).getTagName();
                String value = this.otherInfo.get(name);
                return Integer.parseInt(value.toString());
            }
            return Integer.MIN_VALUE;
        }
        Object value = this.properties.get(key);
        if (value == null) {
            return Integer.MIN_VALUE;
        }
        return ((Number)value).intValue();
    }

    public long getLongProperty(Object key) {
        if (null == key) {
            throw new NullPointerException("arg name can't be null");
        }
        if (this.properties == null || this.properties.isEmpty()) {
            if (!this.otherInfo.isEmpty() && key instanceof TLVTag) {
                String name = ((TLVTag)key).getTagName();
                String value = this.otherInfo.get(name);
                return Long.parseLong(value.toString());
            }
            return Long.MIN_VALUE;
        }
        Object value = this.properties.get(key);
        if (value == null) {
            return Long.MIN_VALUE;
        }
        return ((Number)value).longValue();
    }

    public double getDoubleProperty(Object key) {
        if (null == key) {
            throw new NullPointerException("arg name can't be null");
        }
        if (this.properties == null || this.properties.isEmpty()) {
            if (!this.otherInfo.isEmpty() && key instanceof TLVTag) {
                String name = ((TLVTag)key).getTagName();
                String value = this.otherInfo.get(name);
                return Double.parseDouble(value.toString());
            }
            return Double.MIN_VALUE;
        }
        Object value = this.properties.get(key);
        if (value == null) {
            return Double.MIN_VALUE;
        }
        return ((Number)value).doubleValue();
    }

    public Boolean getBoolProperty(Object key) {
        if (null == key) {
            throw new NullPointerException("arg name can't be null");
        }
        if (this.properties == null || this.properties.isEmpty()) {
            if (!this.otherInfo.isEmpty() && key instanceof TLVTag) {
                String name = ((TLVTag)key).getTagName();
                String value = this.otherInfo.get(name);
                return Boolean.parseBoolean(value.toString());
            }
            return false;
        }
        Object value = this.properties.get(key);
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    public void setProperty(Object key, Object value) {
        if (null == key) {
            throw new NullPointerException("arg name can't be null");
        }
        this.properties.put(key, value);
    }

    public void setProperty(Map<Object, Object> propertyMap) {
        if (null == propertyMap) {
            throw new NullPointerException("arg name can't be null");
        }
        this.properties.putAll(propertyMap);
    }

    public <T> T getProperty(Object key, Class<T> type) {
        if (null == type) {
            throw new NullPointerException("type can't be null");
        }
        return type.cast(this.getProperty(key));
    }

    public <T> T getProperty(Object key, Class<T> type, T defaultValue) {
        if (null == type) {
            throw new NullPointerException("type can't be null");
        }
        try {
            T value = type.cast(this.getProperty(key));
            if (null == value) {
                value = defaultValue;
            }
            return value;
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public String toString() {
        ToStringBuilder tb = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("UUID", (Object)this.getUUID()).append("parentUUID", (Object)this.parentUUID);
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            tb.append(entry.getKey().toString(), entry.getValue());
        }
        return tb.toString();
    }

    public String toJSONStr() {
        return "{}";
    }

    public Object clone() throws CloneNotSupportedException {
        MO component = (MO)super.clone();
        if (this.properties != null) {
            component.properties = new HashMap<Object, Object>(0);
            Object key = null;
            Object value = null;
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (null == value) {
                    component.properties.put(key, null);
                    continue;
                }
                value = this.cloneCollection1(value);
                value = this.cloneCollection2(value);
                component.properties.put(key, value);
            }
        }
        return component;
    }

    private Object cloneCollection1(Object value) {
        if (value instanceof ArrayList) {
            return ((ArrayList)value).clone();
        }
        if (value instanceof HashSet) {
            return ((HashSet)value).clone();
        }
        if (value instanceof EnumSet) {
            return ((EnumSet)value).clone();
        }
        if (value instanceof LinkedHashSet) {
            return ((LinkedHashSet)value).clone();
        }
        if (value instanceof LinkedList) {
            return ((LinkedList)value).clone();
        }
        if (value instanceof TreeSet) {
            return ((TreeSet)value).clone();
        }
        return value;
    }

    private Object cloneCollection2(Object value) {
        if (value instanceof Vector) {
            return ((Vector)value).clone();
        }
        if (value instanceof Hashtable) {
            return ((Hashtable)value).clone();
        }
        if (value instanceof EnumMap) {
            return ((EnumMap)value).clone();
        }
        if (value instanceof HashMap) {
            return ((HashMap)value).clone();
        }
        if (value instanceof TreeMap) {
            return ((TreeMap)value).clone();
        }
        return value;
    }

    public String getDeviceID() {
        return this.uuid.getDeviceID();
    }

    public Map<Object, Object> getProperties() {
        return this.properties;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public void setOtherInfo(Map<String, String> otherInfo) {
        this.otherInfo = new HashMap<String, String>();
        this.updateOtherInfo(otherInfo);
    }

    public void updateOtherInfo(Map<String, String> otherInfo) {
        for (Map.Entry<String, String> entry : otherInfo.entrySet()) {
            String dataKey = entry.getKey();
            if (dataKey.contains("_")) {
                dataKey = dataKey.replace("_", "");
            }
            this.otherInfo.put(dataKey, entry.getValue());
        }
    }
}

