/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.thread;

import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskGroup {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskGroup.class);
    private Collection<FutureTask> taskList = new Vector<FutureTask>();
    private ExecutorService executor;

    public TaskGroup(ExecutorService executorIn) {
        this.executor = executorIn;
    }

    public void addTask(FutureTask task) {
        this.executor.execute(task);
        this.taskList.add(task);
    }

    public void removeTask(FutureTask task) {
        this.taskList.remove(task);
    }

    public Collection<FutureTask> getAllTasks() {
        return this.taskList;
    }

    public boolean isAllTasksOver() {
        for (FutureTask task : this.taskList) {
            if (task.isDone()) continue;
            return false;
        }
        return true;
    }

    public void waitForAllTasksOver() {
        for (FutureTask task : this.taskList) {
            try {
                task.get();
            }
            catch (InterruptedException e) {
                LOGGER.error(e.toString());
            }
            catch (ExecutionException e) {
                LOGGER.error("Task error, stacktrace as below:", e.getCause());
            }
        }
    }

    public void clear() {
        this.taskList.clear();
    }
}

