/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv;

import com.huawei.ism.tlv.TLVTag;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TLVMsgDefine {
    private static final Logger LOGGER = LoggerFactory.getLogger(TLVMsgDefine.class);
    private SortedMap<Integer, TLVTag> tagsMap = null;

    public TLVTag getTag(int tagValue) {
        this.extractTLVTags();
        return (TLVTag)this.tagsMap.get(tagValue);
    }

    public List<TLVTag> getTLVTags() {
        this.extractTLVTags();
        return new ArrayList<TLVTag>(this.tagsMap.values());
    }

    private void extractTLVTags() {
        if (null != this.tagsMap) {
            return;
        }
        this.tagsMap = Collections.synchronizedSortedMap(new TreeMap());
        Field[] fields = this.getClass().getFields();
        Object tag = null;
        TLVTag tlvTag = null;
        for (Field field : fields) {
            try {
                tag = field.get(this);
                if (!(tag instanceof TLVTag)) continue;
                tlvTag = (TLVTag)tag;
                this.tagsMap.put(tlvTag.getParamIndex(), tlvTag);
            }
            catch (RuntimeException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }
}

