/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.bean;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.bean.MessageHead;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataPackage {
    private static Map<Long, List<ParamHideCfg>> pwdHiddenMap;
    private MessageHead head;
    private List<Record> recordset = new ArrayList<Record>(0);

    public void addRecord(Record record) {
        this.recordset.add(record);
    }

    public int getRecordCount() {
        return this.recordset.size();
    }

    public void addRecord(int index, Record record) {
        this.recordset.add(index, record);
    }

    public MessageHead getHead() {
        return this.head;
    }

    public void setHead(MessageHead head) {
        this.head = head;
    }

    public List<Record> getRecordset() {
        return this.recordset;
    }

    public void setRecordset(List<Record> recordset) {
        this.recordset = recordset;
    }

    public byte[] toByteArray() throws IOException {
        if (null == this.head) {
            throw new IOException("Message Head is null");
        }
        int version = this.head.getVersion();
        ByteArrayOutputStream body = new ByteArrayOutputStream();
        int len = 0;
        if (null != this.recordset) {
            byte[] recordDatas = null;
            for (Record record : this.recordset) {
                recordDatas = record.toByteArray(version);
                len += recordDatas.length;
                body.write(recordDatas);
            }
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        this.head.setDataLength(len);
        result.write(this.head.toByteArray());
        result.write(body.toByteArray());
        byte[] ret = result.toByteArray();
        body.close();
        result.close();
        return ret;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DataPackage [head=").append(this.head).append(", recordset=");
        int[] hdinds = null;
        if (!this.recordset.isEmpty()) {
            Record r = this.recordset.get(0);
            hdinds = DataPackage.getHideParamIndex(r.getMsgCode(), r);
        }
        for (Record r : this.recordset) {
            sb.append(r.toString(hdinds));
        }
        sb.append(']');
        return sb.toString();
    }

    private static boolean matchParam(Pair[] paramCond, Record r) {
        for (Pair paramcond : paramCond) {
            Param p = r.getParam(paramcond.index);
            if (p != null && p.getValue().toString().equals(paramcond.v.toString())) continue;
            return false;
        }
        return true;
    }

    public static int[] getHideParamIndex(long cmd, Record r) {
        List<ParamHideCfg> cfgs = pwdHiddenMap.get(cmd);
        if (cfgs == null) {
            return new int[0];
        }
        for (ParamHideCfg cfg : cfgs) {
            if (!DataPackage.matchParam(cfg.paramCond, r)) continue;
            return cfg.paramNeedHide;
        }
        return new int[0];
    }

    private static void put(Map<Long, List<ParamHideCfg>> map, long cmd, ParamHideCfg cfg) {
        List<ParamHideCfg> v = map.get(cmd);
        if (v == null) {
            v = new ArrayList<ParamHideCfg>();
            map.put(cmd, v);
        }
        v.add(cfg);
    }

    private static void setNeedDealHiddenValue() {
        pwdHiddenMap = new HashMap<Long, List<ParamHideCfg>>(0);
        Pair[] emptyarray = new Pair[]{};
        ParamHideCfg alarmRestorePW = new ParamHideCfg(emptyarray, new int[]{TLV.AlarmRestore.CMO_ALARM_RESTORE_PASSWD.getParamIndex()});
        DataPackage.put(pwdHiddenMap, 55847747616L, alarmRestorePW);
        DataPackage.put(pwdHiddenMap, 55847747617L, alarmRestorePW);
        ParamHideCfg staticRestor = new ParamHideCfg(emptyarray, new int[]{TLV.PerfDataRestore.CMO_STATISTIC_RESTORE_PASSWD.getParamIndex()});
        DataPackage.put(pwdHiddenMap, 55847747620L, staticRestor);
        DataPackage.put(pwdHiddenMap, 55847747660L, staticRestor);
        ParamHideCfg emailpasswd = new ParamHideCfg(emptyarray, new int[]{TLV.EMAIL.CMO_EMAIL_SMTP_USER_PASSWD.getParamIndex()});
        DataPackage.put(pwdHiddenMap, 55847747639L, emailpasswd);
        DataPackage.put(pwdHiddenMap, 55847747653L, emailpasswd);
        DataPackage.put(pwdHiddenMap, 55847747640L, emailpasswd);
        DataPackage.put(pwdHiddenMap, 55847813121L, new ParamHideCfg(emptyarray, new int[]{TLV.USER.PASSWORD.getParamIndex()}));
        DataPackage.put(pwdHiddenMap, 55847747659L, new ParamHideCfg(emptyarray, new int[]{TLV.USER.POWEROFFPASSWORD.getParamIndex()}));
        ParamHideCfg userpasswd = new ParamHideCfg(new Pair[]{new Pair(TLV.USER.TYPE.getParamIndex(), MOType.USER.getValue())}, new int[]{TLV.USER.PASSWORD.getParamIndex(), TLV.USER.OLDPASSWORD.getParamIndex()});
        DataPackage.put(pwdHiddenMap, 0xD00004000L, userpasswd);
        DataPackage.put(pwdHiddenMap, 0xD00002000L, userpasswd);
        ParamHideCfg remotedevicepasswd = new ParamHideCfg(new Pair[]{new Pair(TLV.RemoteDevice.TYPE.getParamIndex(), MOType.REMOTE_DEVICE.getValue())}, new int[]{TLV.RemoteDevice.REMOTEPASSWORD.getParamIndex()});
        DataPackage.put(pwdHiddenMap, 0xD00002000L, remotedevicepasswd);
        DataPackage.put(pwdHiddenMap, 55849254913L, new ParamHideCfg(emptyarray, new int[]{TLV.RemoteDeviceBuilder.ISCSILINK_REMOTEPASSWORD.getParamIndex(), TLV.RemoteDeviceBuilder.ISCSILINKCHAPPASSWD.getParamIndex()}));
        ParamHideCfg iscsiinipasswd = new ParamHideCfg(new Pair[]{new Pair(TLV.ISCSIInitiator.TYPE.getParamIndex(), MOType.ISCSI_INITIATOR.getValue())}, new int[]{TLV.ISCSIInitiator.CHAPPASSWORD.getParamIndex()});
        DataPackage.put(pwdHiddenMap, 0xD00002000L, iscsiinipasswd);
        DataPackage.put(pwdHiddenMap, 0xD00000000L, iscsiinipasswd);
        DataPackage.put(pwdHiddenMap, 0xD0000C000L, iscsiinipasswd);
        DataPackage.put(pwdHiddenMap, 0xD00004000L, iscsiinipasswd);
        ParamHideCfg ldappasswd = new ParamHideCfg(new Pair[]{new Pair(TLV.LDAPCONFIG.TYPE.getParamIndex(), MOType.LDAPConfig.getValue())}, new int[]{TLV.LDAPCONFIG.BINDPASSWD.getParamIndex()});
        DataPackage.put(pwdHiddenMap, 0xD00002000L, ldappasswd);
        DataPackage.put(pwdHiddenMap, 0xD00000000L, ldappasswd);
        DataPackage.put(pwdHiddenMap, 0xD0000C000L, ldappasswd);
        DataPackage.put(pwdHiddenMap, 0xD00004000L, ldappasswd);
    }

    static {
        DataPackage.setNeedDealHiddenValue();
    }

    private static class ParamHideCfg {
        private Pair[] paramCond;
        private int[] paramNeedHide;

        public ParamHideCfg(Pair[] pc, int[] ph) {
            this.paramCond = pc;
            this.paramNeedHide = ph;
        }
    }

    private static class Pair {
        private int index;
        private Object v;

        public Pair(int tempInt, Object obj) {
            this.index = tempInt;
            this.v = obj;
        }
    }
}

