/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.lang;

import com.huawei.ism.tlv.lang.IsmSignedInteger;

public class SignedInt16
extends IsmSignedInteger {
    private static final long serialVersionUID = -335923604368968730L;
    private final int signedIntvalue;

    public SignedInt16(int value) {
        this.signedIntvalue = value;
    }

    public SignedInt16(short value) {
        this.signedIntvalue = value;
    }

    public SignedInt16(byte[] bytes) {
        this.signedIntvalue = this.fromByteArray(bytes, bytes.length);
    }

    public SignedInt16(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 2) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[2];
        System.arraycopy(bytes, offset, tmp, 0, 2);
        this.signedIntvalue = this.fromByteArray(tmp, tmp.length);
    }

    protected int fromByteArray(byte[] abyte0, int bytesToRead) {
        if (abyte0.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        int arrayLength = abyte0.length;
        int count = bytesToRead >= 2 ? 2 : bytesToRead;
        int value = abyte0[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            value <<= 8;
            value |= abyte0[arrayLength - count] & 0xFF;
        }
        return value;
    }

    @Override
    public byte[] toByteArray() {
        byte[] returnArray = new byte[2];
        returnArray[1] = (byte)(this.signedIntvalue >>> 8 & 0xFF);
        returnArray[0] = (byte)this.signedIntvalue;
        return returnArray;
    }

    @Override
    public double doubleValue() {
        return this.signedIntvalue;
    }

    @Override
    public float floatValue() {
        return this.signedIntvalue;
    }

    @Override
    public int intValue() {
        return this.signedIntvalue;
    }

    @Override
    public long longValue() {
        return this.signedIntvalue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.signedIntvalue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignedInt16 other = (SignedInt16)obj;
        return this.signedIntvalue == other.signedIntvalue;
    }
}

