/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.lang;

import com.huawei.ism.tlv.lang.IsmSignedInteger;

public class SignedInt64
extends IsmSignedInteger {
    private static final long serialVersionUID = -2709436714093579811L;
    private long value;

    public SignedInt64(long value) {
        this.value = value;
    }

    public SignedInt64(byte[] bytes) {
        this.value = this.fromByteArray(bytes, bytes.length);
    }

    public SignedInt64(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 8) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[8];
        System.arraycopy(bytes, offset, tmp, 0, 8);
        this.fromByteArray(tmp, tmp.length);
    }

    private long fromByteArray(byte[] values, int bytesToRead) {
        if (values.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        long longValue = 0L;
        int arrayLength = values.length;
        int count = bytesToRead >= 8 ? 8 : bytesToRead;
        longValue = values[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            longValue <<= 8;
            longValue |= (long)(values[arrayLength - i] & 0xFF);
        }
        return longValue;
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[]{(byte)(this.value >>> 0), (byte)(this.value >>> 8), (byte)(this.value >>> 16), (byte)(this.value >>> 24), (byte)(this.value >>> 32), (byte)(this.value >>> 40), (byte)(this.value >>> 48), (byte)(this.value >>> 56)};
        return bytes;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.value ^ this.value >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SignedInt64 other = (SignedInt64)obj;
        return this.value == other.value;
    }
}

