/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;

public class ControllerMO
extends HardwareInfoAdapter {
    public static final int CONTROLLER_A = 0;
    public static final int CONTROLLER_B = 1;
    private final MO mo;

    public ControllerMO(MO mo) {
        this.mo = mo;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        return MOType.getType(Integer.parseInt(this.mo.getProperty(TLV.CONTROLLER.TYPE).toString()));
    }

    public void setType(MOType type) {
        this.mo.setProperty(TLV.CONTROLLER.TYPE, type.getValue());
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.CONTROLLER.ID);
    }

    public void setID(String id) {
        this.mo.setProperty(TLV.CONTROLLER.ID, id);
    }

    public String getMOName() {
        return ResourceManager.getStringWithParams("physical.controller.name", this.getName());
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.CONTROLLER.NAME);
    }

    public void setName(String name) {
        this.mo.setProperty(TLV.CONTROLLER.NAME, name);
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.CONTROLLER.PARENTTYPE).toString());
    }

    public void setParentType(MOType parentType) {
        this.mo.setProperty(TLV.CONTROLLER.PARENTTYPE, parentType.getValue());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.CONTROLLER.PARENTID);
    }

    public void setParentID(String parentID) {
        this.mo.setProperty(TLV.CONTROLLER.PARENTID, parentID);
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.CONTROLLER.LOCATION);
    }

    public void setLocation(String location) {
        this.mo.setProperty(TLV.CONTROLLER.LOCATION, location);
    }

    @Override
    public int getHealthStatus() {
        return Integer.parseInt(this.mo.getProperty(TLV.CONTROLLER.HEALTHSTATUS).toString());
    }

    public void setHealthStatus(EnumDefine.HEALTH_STATUS_E healthStatus) {
        this.mo.setProperty(TLV.CONTROLLER.HEALTHSTATUS, healthStatus.getValue());
    }

    public EnumDefine.RUNNING_STATUS_E getRunningStatus() {
        return EnumDefine.RUNNING_STATUS_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.CONTROLLER.RUNNINGSTATUS).toString()));
    }

    public void setRunningStatus(EnumDefine.RUNNING_STATUS_E runningStatus) {
        this.mo.setProperty(TLV.CONTROLLER.RUNNINGSTATUS, runningStatus.getValue());
    }

    public String getDescription() {
        return this.mo.getStrProperty(TLV.CONTROLLER.DESCRIPTION);
    }

    public long getCount() {
        return this.mo.getLongProperty(TLV.CONTROLLER.COUNT);
    }

    public String getSoftVer() {
        return this.mo.getStrProperty(TLV.CONTROLLER.SOFTVER);
    }

    public long getTemperature() {
        return this.mo.getLongProperty(TLV.CONTROLLER.TEMPERATURE);
    }

    public boolean isIsMaster() {
        return this.mo.getBoolProperty(TLV.CONTROLLER.ISMASTER);
    }

    public String getElabel() {
        return this.mo.getStrProperty(TLV.CONTROLLER.ELABEL);
    }

    public String getPcbVer() {
        return this.mo.getStrProperty(TLV.CONTROLLER.PCBVER);
    }

    public String getSesVer() {
        return this.mo.getStrProperty(TLV.CONTROLLER.SESVER);
    }

    public String getBmcVer() {
        return this.mo.getStrProperty(TLV.CONTROLLER.BMCVER);
    }

    public String getLogicVer() {
        return this.mo.getStrProperty(TLV.CONTROLLER.LOGICVER);
    }

    public String getBiosVer() {
        return this.mo.getStrProperty(TLV.CONTROLLER.BIOSVER);
    }

    public Object getAllTemperature() {
        return this.mo.getProperty(TLV.CONTROLLER.ALLTEMPERATURE);
    }

    public long getMemorySize() {
        return this.mo.getLongProperty(TLV.CONTROLLER.MEMORYSIZE);
    }

    public String getCpuInfo() {
        return this.mo.getStrProperty(TLV.CONTROLLER.CPUINFO);
    }

    public void setCpuInfo(String cpuInfo) {
        this.mo.setProperty(TLV.CONTROLLER.CPUINFO, cpuInfo);
    }

    public void setLightStatus(EnumDefine.SWITCH_E lightStatus) {
        this.mo.setProperty(TLV.CONTROLLER.LIGHT_STATUS, (Object)lightStatus);
    }

    public EnumDefine.SWITCH_E getLightStatus() {
        if (this.mo.getProperty(TLV.CONTROLLER.LIGHT_STATUS) == null) {
            return null;
        }
        return EnumDefine.SWITCH_E.valueOf(Integer.parseInt(this.mo.getProperty(TLV.CONTROLLER.LIGHT_STATUS).toString()));
    }

    public long getCpuUsage() {
        return this.mo.getLongProperty(TLV.CONTROLLER.CPUUSAGE);
    }

    public long getMemoryUsage() {
        return this.mo.getLongProperty(TLV.CONTROLLER.MEMORYUSAGE);
    }

    @Override
    public boolean isNormal() {
        return true;
    }
}

