/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MOType;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HardwareInfoAdapter
implements IHardwareInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardwareInfoAdapter.class);

    @Override
    public String getModelName() {
        Object model = this.getModel();
        if (null == model) {
            return null;
        }
        Class<?> cls = model.getClass();
        String modelStr = null;
        if (!cls.isEnum()) {
            return model.toString();
        }
        try {
            Method method = cls.getMethod("name", new Class[0]);
            modelStr = (String)method.invoke(model, new Object[0]);
        }
        catch (SecurityException exception) {
            LOGGER.error("Security exception.", (Throwable)exception);
        }
        catch (Exception exception) {
            LOGGER.error("Get model string error.", (Throwable)exception);
        }
        return modelStr;
    }

    public Object getModel() {
        return null;
    }

    @Override
    public String getTypeName() {
        MOType type = this.getType();
        return null == type ? null : type.name();
    }

    public abstract MOType getType();
}

