/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.EnumDefine;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.framework.pubservice.hardware.HardwareInfoAdapter;
import com.huawei.ism.tool.framework.pubservice.hardware.IPortInfo;

public class SasPortMO
extends HardwareInfoAdapter
implements IPortInfo {
    private final MO mo;

    public SasPortMO(MO mo) {
        this.mo = mo;
    }

    @Override
    public boolean isNormal() {
        return true;
    }

    public UUID getUUID() {
        return this.mo.getUUID();
    }

    @Override
    public MOType getType() {
        Object moObject = this.mo.getProperty(TLV.SAS_PORT.TYPE);
        if (null == moObject) {
            return null;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return MOType.getType(value);
    }

    public int getSlotID() {
        return (int)(Long.valueOf(this.getID()) & 0xFFL);
    }

    public void setType(MOType type) {
        this.mo.setProperty(TLV.SAS_PORT.TYPE, type.getValue());
    }

    @Override
    public String getID() {
        return this.mo.getStrProperty(TLV.SAS_PORT.ID);
    }

    public void setID(String id) {
        this.mo.setProperty(TLV.SAS_PORT.ID, id);
    }

    public String getName() {
        return this.mo.getStrProperty(TLV.SAS_PORT.NAME);
    }

    public void setName(String name) {
        this.mo.setProperty(TLV.SAS_PORT.NAME, name);
    }

    @Override
    public int getParentType() {
        return Integer.parseInt(this.mo.getProperty(TLV.SAS_PORT.PARENTTYPE).toString());
    }

    public void setParentType(MOType parentType) {
        this.mo.setProperty(TLV.SAS_PORT.PARENTTYPE, parentType.getValue());
    }

    @Override
    public String getParentID() {
        return this.mo.getStrProperty(TLV.SAS_PORT.PARENTID);
    }

    public void setParentID(String parentID) {
        this.mo.setProperty(TLV.SAS_PORT.PARENTID, parentID);
    }

    @Override
    public String getLocation() {
        return this.mo.getStrProperty(TLV.SAS_PORT.LOCATION);
    }

    public void setLocation(String location) {
        this.mo.setProperty(TLV.SAS_PORT.LOCATION, location);
    }

    @Override
    public int getHealthStatus() {
        Object moObject = this.mo.getProperty(TLV.SAS_PORT.HEALTHSTATUS);
        if (null == moObject) {
            return -1;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return value;
    }

    public void setHealthStatus(EnumDefine.HEALTH_STATUS_E healthStatus) {
        this.mo.setProperty(TLV.SAS_PORT.HEALTHSTATUS, healthStatus.getValue());
    }

    @Override
    public int getRunningStatus() {
        Object moObject = this.mo.getProperty(TLV.SAS_PORT.RUNNINGSTATUS);
        if (null == moObject) {
            return -1;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return value;
    }

    public void setRunningStatus(EnumDefine.RUNNING_STATUS_E runningStatus) {
        this.mo.setProperty(TLV.SAS_PORT.RUNNINGSTATUS, runningStatus.getValue());
    }

    public EnumDefine.PORT_LOGIC_TYPE_E getLogicType() {
        Object moObject = this.mo.getProperty(TLV.SAS_PORT.LOGICTYPE);
        if (null == moObject) {
            return null;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return EnumDefine.PORT_LOGIC_TYPE_E.valueOf(value);
    }

    public void setLogicType(EnumDefine.PORT_LOGIC_TYPE_E logicType) {
        this.mo.setProperty(TLV.SAS_PORT.LOGICTYPE, logicType.getValue());
    }

    public Long getRunSpeed() {
        return this.mo.getLongProperty(TLV.SAS_PORT.RUNSPEED);
    }

    public void setRunSpeed(Long runSpeed) {
        this.mo.setProperty(TLV.SAS_PORT.RUNSPEED, new UnsignedInt32(runSpeed));
    }

    public String getWwn() {
        return this.mo.getStrProperty(TLV.SAS_PORT.WWN);
    }

    public void setWwn(String wwn) {
        this.mo.setProperty(TLV.SAS_PORT.WWN, wwn);
    }

    public EnumDefine.INI_OR_TGT_E getIniOrTgt() {
        Object moObject = this.mo.getProperty(TLV.SAS_PORT.INIORTGT);
        if (null == moObject) {
            return null;
        }
        Integer value = Integer.parseInt(moObject.toString());
        return EnumDefine.INI_OR_TGT_E.valueOf(value);
    }

    public void setIniOrTgt(EnumDefine.INI_OR_TGT_E iniOrTgt) {
        this.mo.setProperty(TLV.SAS_PORT.INIORTGT, iniOrTgt.getValue());
    }

    public Boolean getPortSwitch() {
        return this.mo.getBoolProperty(TLV.SAS_PORT.PORTSWITCH);
    }

    public void setPortSwitch(Boolean portSwitch) {
        this.mo.setProperty(TLV.SAS_PORT.PORTSWITCH, portSwitch);
    }

    public Long getInvalidDword() {
        return this.mo.getLongProperty(TLV.SAS_PORT.INVALIDDWORD);
    }

    public void setInvalidDword(Long invalidDword) {
        this.mo.setProperty(TLV.SAS_PORT.INVALIDDWORD, new UnsignedInt32(invalidDword));
    }

    public Long getDisparityError() {
        return this.mo.getLongProperty(TLV.SAS_PORT.DISPARITYERROR);
    }

    public void setDisparityError(Long disparityError) {
        this.mo.setProperty(TLV.SAS_PORT.DISPARITYERROR, new UnsignedInt32(disparityError));
    }

    public Long getLossDword() {
        return this.mo.getLongProperty(TLV.SAS_PORT.LOSSDWORD);
    }

    public void setLossDword(Long lossDword) {
        this.mo.setProperty(TLV.SAS_PORT.LOSSDWORD, new UnsignedInt32(lossDword));
    }

    public Long getPHYResetErrors() {
        return this.mo.getLongProperty(TLV.SAS_PORT.PHYRESETERRORS);
    }

    public void setPHYResetErrors(Long phyResetErrors) {
        this.mo.setProperty(TLV.SAS_PORT.PHYRESETERRORS, new UnsignedInt32(phyResetErrors));
    }

    public Long getStartTime() {
        return this.mo.getLongProperty(TLV.SAS_PORT.STARTTIME);
    }

    public void setStartTime(Long startTime) {
        this.mo.setProperty(TLV.SAS_PORT.STARTTIME, new UnsignedInt32(startTime));
    }

    public void setCurrentPeerID(String currentPeerID) {
        this.mo.setProperty(TLV.SAS_PORT.CURRENT_PEER_ID, currentPeerID);
    }

    @Override
    public String getCurrentPeerID() {
        return this.mo.getStrProperty(TLV.SAS_PORT.CURRENT_PEER_ID);
    }

    public void setSuggestPeerID(String suggestPeerID) {
        this.mo.setProperty(TLV.SAS_PORT.SUGGEST_PEER_ID, suggestPeerID);
    }

    @Override
    public String getSuggestPeerID() {
        return this.mo.getStrProperty(TLV.SAS_PORT.SUGGEST_PEER_ID);
    }
}

