/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.lockui;

import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.ui.forms.mainframe.MainFrame;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockUIThread
extends Thread
implements AWTEventListener,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockUIThread.class);
    private static final long serialVersionUID = -802217990245021321L;
    private static final int DEFAULT_INTERVAL_TIME_MINUTE = 10;
    private static final int INVALID_TIME = -1;
    private static final int MINUTE_TO_MILLIS = 60000;
    private int intervalTime;
    private boolean autoLockUI = true;
    private final Object lockUI = new Object();
    private long time = System.currentTimeMillis();
    private MainFrame mainframe = null;

    public LockUIThread(MainFrame mainFrame) {
        this.mainframe = mainFrame;
        int intervalTimeTemp = this.getIntervalTimeFormCfgFile();
        this.intervalTime = intervalTimeTemp > 0 ? intervalTimeTemp : 10;
        this.setName("Lock UI Processor");
        this.setDaemon(true);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 16L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        Toolkit.getDefaultToolkit().addAWTEventListener(this, 4L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long currentTime = 0L;
            long interval = 0L;
            while (true) {
                Thread.sleep(5000L);
                Object object = this.lockUI;
                synchronized (object) {
                    while (!this.autoLockUI) {
                        this.lockUI.wait();
                        this.time = System.currentTimeMillis();
                    }
                }
                if (this.mainframe.isLock() || (interval = ((currentTime = System.currentTimeMillis()) - this.time) / 60000L) < (long)this.intervalTime) continue;
                this.mainframe.setLock(true);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (Throwable t) {
            LOGGER.error(t.getMessage(), t);
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        this.time = System.currentTimeMillis();
    }

    public int getIntervalTime() {
        return this.intervalTime;
    }

    public void setIntervalTime(int timeTemp) {
        this.intervalTime = timeTemp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoLock(boolean lock) {
        this.autoLockUI = lock;
        if (lock) {
            Object object = this.lockUI;
            synchronized (object) {
                this.lockUI.notifyAll();
            }
        }
    }

    private int getIntervalTimeFormCfgFile() {
        int result = -1;
        try {
            CustomResourceManager resource = CustomResourceManager.getInstance();
            String timeTemp = resource.getString("custom.LockTime", "30");
            result = Integer.valueOf(timeTemp);
            String autoLock = resource.getString("custom.AutoLock", "true");
            String enableLock = resource.getString("custom.EnableLockScreenFunction", "true");
            this.setAutoLock(Boolean.parseBoolean(autoLock) || Boolean.parseBoolean(enableLock));
        }
        catch (Exception e) {
            LOGGER.error("get lock time from profile.xml erro", (Throwable)e);
        }
        return result;
    }
}

