/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.lockui;

import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.ui.forms.mainframe.MainFrame;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockedDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockedDialog.class);
    private static final int DIALOG_WIDTH = 392;
    private static final int DIALOG_HEIGHT = 200;
    private static final int ICON_TEXT_PAD = 12;
    private static final Dimension TEXT_AREA_SIZE = new Dimension(100, 200);
    private static final int BUTTON_DISTANCE = 4;
    private static final long serialVersionUID = -7825881644660219803L;
    private JPanel wholePanel;
    private boolean isLock;
    private MainFrame frame;
    private JLabel lockIconLabel = new JLabel();
    private IsmTextArea textArea = new IsmTextArea();
    private JPanel releaseWholePanel;
    private JLabel releaseIconLabel = new JLabel();
    private IsmTextArea releaseTextArea = new IsmTextArea();
    private IsmPasswordField passwordField = new IsmPasswordField(16);
    private JButton confirmButton = new JButton();
    private JButton cancelButton = new JButton();
    private boolean show = true;

    public LockedDialog(MainFrame mainFrame) {
        super(mainFrame);
        this.setName("ISMV1R2_framework_lockUI_LockedDialog");
        this.setNameForAutoTest();
        this.frame = mainFrame;
        String lockPwd = CustomResourceManager.getInstance().getString("custom.LockPwd");
        if (null == lockPwd || "".equals(lockPwd)) {
            this.passwordField.setEnabled(false);
        }
        this.initComponentLock();
        this.initLayoutLock();
        this.initComponentRelease();
        this.initLayoutRelease();
        this.initEventRelease();
        this.showLockOrRelease(true);
        SwingUtil.putParentCenter(this, mainFrame);
    }

    public void showLockOrRelease(boolean lock) {
        this.isLock = lock;
        if (!this.isLock) {
            this.setSize(392, 200);
            this.setTitle(ResourceManager.getString("RELEASE_DIALOG_TITLE"));
            this.setContentPane(this.releaseWholePanel);
            this.validate();
            this.repaint();
            if (this.passwordField.isEnabled()) {
                this.passwordField.requestFocus();
            } else {
                this.confirmButton.requestFocus();
            }
        } else {
            this.setSize(392, 200);
            this.setTitle(ResourceManager.getString("LOCKED_DIALOG_TITLE"));
            this.setContentPane(this.wholePanel);
            this.validate();
            this.repaint();
            this.wholePanel.requestFocus();
        }
    }

    protected void initComponentLock() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                LockedDialog.this.show = !LockedDialog.this.show;
                LockedDialog.this.showLockOrRelease(LockedDialog.this.show);
            }
        });
        this.setResizable(false);
        this.setModal(true);
        this.lockIconLabel.setIcon(ResourceManager.getImage("lock.png"));
        this.textArea.setText(MessageFormat.format(ResourceManager.getString("LOCKED_DIALOG_TEXT"), ""));
        this.textArea.setPreferredSize(TEXT_AREA_SIZE);
        this.textArea.setLineWrap(true);
        this.passwordField.getPasswordPopupInfo().removeAllInform();
    }

    protected void initLayoutLock() {
        this.wholePanel = new JPanel();
        this.wholePanel.setName("ISMV1R2_framework_LockedDialog_wholePanel");
        this.wholePanel.setLayout(new BorderLayout(0, 0));
        Box wholeBox = Box.createVerticalBox();
        Box downBox = Box.createHorizontalBox();
        this.wholePanel.setFocusable(true);
        this.wholePanel.addKeyListener(new PaneKeyAdapter());
        this.lockIconLabel.setAlignmentY(0.0f);
        this.textArea.setAlignmentY(0.0f);
        this.textArea.setFocusable(false);
        this.textArea.setEditable(false);
        downBox.add(Box.createHorizontalStrut(20));
        downBox.add(this.lockIconLabel);
        downBox.add(Box.createHorizontalStrut(12));
        downBox.add(this.textArea);
        downBox.add(Box.createHorizontalStrut(20));
        downBox.setAlignmentX(0.0f);
        wholeBox.add(Box.createVerticalStrut(30));
        wholeBox.add(downBox);
        wholeBox.add(Box.createVerticalStrut(12));
        this.wholePanel.add((Component)wholeBox, "North");
    }

    protected void initComponentRelease() {
        this.releaseIconLabel.setIcon(ResourceManager.getImage("key.gif"));
        this.releaseTextArea.setText(MessageFormat.format(ResourceManager.getString("RELEASE_DIALOG_TEXT"), ""));
        this.releaseTextArea.setLineWrap(true);
        this.releaseTextArea.setPreferredSize(new Dimension(290, 55));
        this.passwordField.getPasswordPopupInfo().removeAllInform();
        this.passwordField.setPreferredSize(new Dimension(500, 20));
        this.confirmButton.setText(ResourceManager.getString("RELEASE_DIALOG_CONFIRM"));
        this.confirmButton.setMnemonic(79);
        this.cancelButton.setText(ResourceManager.getString("RELEASE_DIALOG_CANCEL"));
        this.cancelButton.setMnemonic(67);
        UCD.setJComponentSize(this.confirmButton, new Dimension(80, 20));
        UCD.setJComponentSize(this.cancelButton, new Dimension(80, 20));
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (null != this.wholePanel && !this.wholePanel.hasFocus()) {
            this.wholePanel.requestFocus();
        }
    }

    protected void initLayoutRelease() {
        this.releaseWholePanel = new JPanel();
        this.releaseWholePanel.setName("ISMV1R2_framework_LockedDialog_releaseWholePanel");
        this.releaseWholePanel.setLayout(new BorderLayout(0, 0));
        Box wholeBox = Box.createVerticalBox();
        Box downBox = Box.createHorizontalBox();
        Box contentBox = this.getReleaseContentBox();
        this.releaseIconLabel.setAlignmentY(0.0f);
        contentBox.setAlignmentY(0.0f);
        downBox.add(Box.createHorizontalStrut(20));
        downBox.add(this.releaseIconLabel);
        downBox.add(Box.createHorizontalStrut(12));
        downBox.add(contentBox);
        downBox.add(Box.createHorizontalStrut(20));
        downBox.setAlignmentX(0.0f);
        wholeBox.add(Box.createVerticalStrut(20));
        wholeBox.add(downBox);
        wholeBox.add(Box.createVerticalStrut(12));
        this.releaseWholePanel.add((Component)wholeBox, "South");
    }

    protected void initEventRelease() {
        this.passwordField.addKeyListener(new PasswordFieldKeyAdapter());
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockedDialog.this.confirmActionRelease();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockedDialog.this.cancelActionRelease();
            }
        });
    }

    protected Box getReleaseContentBox() {
        Box contentBox = Box.createVerticalBox();
        Box usernameBox = Box.createHorizontalBox();
        Box passwordBox = Box.createHorizontalBox();
        Box buttonBox = Box.createHorizontalBox();
        this.releaseTextArea.setAlignmentX(0.0f);
        this.releaseTextArea.setFocusable(false);
        this.releaseTextArea.setEditable(false);
        usernameBox.setAlignmentX(0.0f);
        passwordBox.setAlignmentX(0.0f);
        buttonBox.setAlignmentX(0.0f);
        passwordBox.add(new JLabel(ResourceManager.getString("RELEASE_DIALOG_PASSWORD")));
        passwordBox.add(Box.createHorizontalStrut(12));
        passwordBox.add(this.passwordField);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.confirmButton);
        buttonBox.add(Box.createHorizontalStrut(4));
        buttonBox.add(this.cancelButton);
        contentBox.add(this.releaseTextArea);
        contentBox.add(usernameBox);
        contentBox.add(Box.createVerticalStrut(12));
        contentBox.add(passwordBox);
        contentBox.add(Box.createVerticalStrut(12));
        contentBox.add(buttonBox);
        return contentBox;
    }

    protected void confirmActionRelease() {
        if (this.isLock) {
            return;
        }
        String encodePassword = Utils.getStringValueOfPassordFiled(this.passwordField);
        String ret = AESEncrypt.encrypt(encodePassword);
        String lockPwd = CustomResourceManager.getInstance().getString("custom.LockPwd");
        if ("".equals(lockPwd) || ret.equals(lockPwd)) {
            this.dispose();
            if (this.frame.isMinimumSizeSet()) {
                this.frame.setState(0);
            }
            this.frame.setLock(false);
            LOGGER.info("Unlock mainFrame !");
        } else {
            String promp = ResourceManager.getString("RELEASE_DIALOG_WRONG_PASSWORD");
            if (encodePassword.equals("")) {
                promp = ResourceManager.getString("RELEASE_DIALOG_WRONG_NULLPWD");
            }
            DialogUtils.showErrorDialog(this, promp);
            this.passwordField.requestFocus();
            this.passwordField.selectAll();
        }
    }

    protected void cancelActionRelease() {
        boolean bl = this.show = !this.show;
        if (this.isLock) {
            return;
        }
        this.showLockOrRelease(true);
        this.passwordField.setText("");
    }

    private void setNameForAutoTest() {
        this.lockIconLabel.setName("ISMV1R2_framework_LockedDialog_lockIconLabel");
        this.textArea.setName("ISMV1R2_framework_LockedDialog_textArea");
        this.releaseIconLabel.setName("ISMV1R2_framework_LockedDialog_releaseIconLabel");
        this.releaseTextArea.setName("ISMV1R2_framework_LockedDialog_releaseTextArea");
        this.passwordField.setName("ISMV1R2_framework_LockedDialog_passwordField");
        this.confirmButton.setName("ISMV1R2_framework_LockedDialog_confirmButton");
        this.cancelButton.setName("ISMV1R2_framework_LockedDialog_cancelButton");
    }

    private class PaneKeyAdapter
    extends KeyAdapter {
        private PaneKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!LockedDialog.this.isLock) {
                return;
            }
            boolean isValidKey = this.isValidKey(keyEvent);
            if (!isValidKey) {
                return;
            }
            LockedDialog.this.show = !LockedDialog.this.show;
            LockedDialog.this.showLockOrRelease(false);
        }

        private boolean isValidKey(KeyEvent keyEvent) {
            boolean isValidKey = keyEvent.isControlDown() && keyEvent.isAltDown() && keyEvent.getKeyCode() == 82;
            return isValidKey;
        }
    }

    private final class PasswordFieldKeyAdapter
    extends KeyAdapter {
        private PasswordFieldKeyAdapter() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            char key = keyEvent.getKeyChar();
            switch (key) {
                case '\n': {
                    LockedDialog.this.confirmActionRelease();
                    break;
                }
                case '\u001b': {
                    LockedDialog.this.cancelActionRelease();
                    break;
                }
            }
        }
    }
}

