/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.mainframe;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.IDataChangeListener;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.UIController;
import com.huawei.ism.ui.forms.mainframe.MainPaneTree;
import com.huawei.ism.ui.forms.mainframe.MainPaneTreeSelectionHandler;
import com.huawei.ism.ui.swing.LayoutConstants;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.ui.widgets.propertypane.DefaultCopyrightPropertyPane;
import com.huawei.ism.ui.widgets.tree.DevicesTreeNode;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class MainPane
extends JSplitPane
implements IDataChangeListener {
    private static final int EMPTY_BORDER_TOP = 12;
    private static final int EMPTY_BORDER_LEFT = 0;
    private static final int EMPTY_BORDER_BOTTOM = -1;
    private static final int EMPTY_BORDER_RIGHT = -1;
    private static final long serialVersionUID = 3837556424968785008L;
    private MainPaneTree ismTree = new MainPaneTree();

    public MainPane() {
        this.setName("ISMV1R2_framework_MainFrame_splitPane");
        this.setBackground(LayoutConstants.PROPERTY_PANE_BACKGROUND_COLOR);
        this.loadComponent();
        UIController.getInstance().addDataChangeListener(this);
    }

    public void addTreeSelectionListener(TreeSelectionListener selectionListener) {
        this.ismTree.addTreeSelectionListener(selectionListener);
    }

    private void loadComponent() {
        JComponent treePane = null;
        treePane = IsmPlafUtils.getLAFStyle() != IsmPlafUtils.LAFStyle.armor ? this.initTreeTabbedPane() : this.initArmorTreeTabbedPane();
        this.setResizeWeight(0.35);
        this.setLeftComponent(treePane);
        String runMode = Framework.getInstance().getRunMode();
        if (!runMode.equals("APPLET")) {
            this.setRightComponent(this.ismTree.getRootNode().getPropertyPane());
        } else {
            this.setRightComponent(DefaultCopyrightPropertyPane.getInstance());
        }
        this.setResizeWeight(0.0);
        this.getMinimumDividerLocation();
        this.setContinuousLayout(true);
    }

    private JComponent initArmorTreeTabbedPane() {
        JScrollPane scrollPane = new JScrollPane();
        JScrollBar hbar = new JScrollBar(0);
        JScrollBar vbar = new JScrollBar(1);
        scrollPane.setVerticalScrollBar(vbar);
        scrollPane.setHorizontalScrollBar(hbar);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.ismTree.setName("Physical");
        this.ismTree.setBackground(new Color(0xE2E2E3));
        this.ismTree.expendsTopNodes();
        EmptyBorder emptyBorder = new EmptyBorder(5, 10, 5, 5);
        this.ismTree.setBorder(emptyBorder);
        scrollPane.setViewportView(this.ismTree);
        TreeMouseListener treeMouseListener = new TreeMouseListener();
        this.ismTree.addMouseListener(treeMouseListener);
        this.ismTree.addTreeSelectionListener(new MainPaneTreeSelectionHandler(this));
        scrollPane.setPreferredSize(new Dimension(200, 0));
        scrollPane.setMinimumSize(new Dimension(200, 0));
        scrollPane.setBorder(new CompoundBorder(new EtchedBorder(), UCD.createEmptyBorder(0)));
        JPanel scrollPanel = new JPanel(new BorderLayout());
        scrollPanel.add((Component)scrollPane, "Center");
        scrollPanel.setBorder(new EmptyBorder(3, 2, 3, 3));
        scrollPanel.setBackground(new Color(0xFFFFFF));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)scrollPanel, "Center");
        contentPanel.setBorder(UCD.createEmptyBorder(3));
        contentPanel.setBackground(new Color(0x49494C));
        return contentPanel;
    }

    private JComponent initTreeTabbedPane() {
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setBorder(BorderFactory.createEmptyBorder(12, 0, -1, -1));
        this.setName("ISM_KaimseFrame_tabbedPain");
        JScrollBar hbar = new JScrollBar(0);
        hbar.setName("ISMV1R2_framework_IsmScrollPane_hbar");
        JScrollBar vbar = new JScrollBar(1);
        vbar.setName("ISMV1R2_framework_IsmScrollPane_vbar");
        scrollPane.setVerticalScrollBar(vbar);
        scrollPane.setHorizontalScrollBar(hbar);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.ismTree.setName("ISMV1R2_framework_TreeTabbedPane_phyTree");
        this.ismTree.setName("Physical");
        this.ismTree.setBackground(new Color(15725560));
        this.ismTree.setBorder(new EmptyBorder(4, 7, 0, 0));
        scrollPane.setViewportView(this.ismTree);
        TreeMouseListener treeMouseListener = new TreeMouseListener();
        this.ismTree.addMouseListener(treeMouseListener);
        this.ismTree.addTreeSelectionListener(new MainPaneTreeSelectionHandler(this));
        scrollPane.setPreferredSize(new Dimension(200, 0));
        scrollPane.setMinimumSize(new Dimension(200, 0));
        return scrollPane;
    }

    public MainPaneTree getLeftTree() {
        return this.ismTree;
    }

    public PropertyPane getRightPane() {
        Component rightComponent = this.getRightComponent();
        if (rightComponent instanceof PropertyPane) {
            PropertyPane pane = (PropertyPane)rightComponent;
            return pane;
        }
        return null;
    }

    public void updateRightPane() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PropertyPane pane = MainPane.this.getRightPane();
                if (null != pane) {
                    pane.autoUpdate();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtil.runInEventDispatchThread(runnable);
        }
    }

    public synchronized void setPropertyPane(final PropertyPane propertyPane) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PropertyPane oldPane = MainPane.this.getRightPane();
                int location = MainPane.this.getDividerLocation();
                MainPane.this.setRightComponent(null);
                MainPane.this.setRightComponent(propertyPane);
                MainPane.this.setDividerLocation(location);
                MainPane.this.validate();
                if (oldPane != null) {
                    oldPane.stopDisplay();
                }
            }
        };
        SwingUtil.runInEventDispatchThread(runnable);
    }

    @Override
    public void dataChanged(IDataChangeListener.DataChangeEvent dataChangeEvent) {
        Set<String> changedDeviceIDSet = dataChangeEvent.getChangedDevice();
        this.updateLeftTree(changedDeviceIDSet);
        this.updateRightPane(changedDeviceIDSet);
    }

    private void updateLeftTree(Collection<String> changedDeviceIDs) {
        MainPaneTree leftTree = this.getLeftTree();
        if (null == leftTree) {
            return;
        }
        IsmTreeNode treeNode = null;
        Launcher launcher = null;
        IsmTreeNode deviceRootNode = null;
        for (String deviceID : changedDeviceIDs) {
            treeNode = leftTree.findRootDeviceNode(deviceID);
            if (null != treeNode) {
                leftTree.updateNodeAndChildren(treeNode);
                continue;
            }
            launcher = LauncherManager.getInstance().findDeviceOwner(deviceID);
            if (null == launcher) {
                throw new NullPointerException();
            }
            deviceRootNode = launcher.getDeviceTreeNode("TREENODE_VIEW_NOMAL");
            if (null == deviceRootNode) continue;
            leftTree.addDeviceTreeNode(deviceRootNode);
        }
        leftTree.treeDidChange();
    }

    private void updateRightPane(Collection<String> changedDeviceIDs) {
        IsmTreeNode treeNode = this.getLeftTree().getSelectionNode();
        if (null == treeNode) {
            this.updateRightPane();
            return;
        }
        if (treeNode instanceof DevicesTreeNode) {
            this.updateRightPane();
            return;
        }
        String deviceID = treeNode.getDeviceID();
        Launcher launcher = null;
        for (String changedDeviceID : changedDeviceIDs) {
            launcher = LauncherManager.getInstance().findDeviceOwner(changedDeviceID);
            if (null == launcher) {
                throw new NullPointerException();
            }
            if (!launcher.containsPart(deviceID)) continue;
            this.updateRightPane();
            break;
        }
    }

    private static class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (3 == mouseEvent.getButton()) {
                JTree tree = (JTree)mouseEvent.getSource();
                if (null == tree) {
                    return;
                }
                TreePath treePath = tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (null == treePath) {
                    return;
                }
                tree.setSelectionPath(treePath);
                IsmTreeNode selectionTreeNode = (IsmTreeNode)treePath.getLastPathComponent();
                JPopupMenu popupMenu = selectionTreeNode.getPopupMenu();
                if (null != popupMenu) {
                    popupMenu.show(tree, mouseEvent.getX(), mouseEvent.getY());
                    popupMenu.setName("ISM_KaimseFrame_popMenu");
                }
            }
        }
    }
}

