/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.mainframe;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import javax.accessibility.Accessible;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SplashComponent
extends JComponent
implements Accessible {
    private static final Logger LOGGER = LoggerFactory.getLogger(SplashComponent.class);
    private static final int PROGRESSBAR_HEIGTH = 10;
    private static final int PROGRESSBAR_WIDTH = 80;
    private static final long serialVersionUID = 4195612692196956784L;
    private Rectangle bar = new Rectangle();
    private int barLength = 0;
    private int barStart = 0;
    private Color colorBar;
    private Color colorCorner;
    private Color colorEdge;
    private Color colorText;
    private Rectangle dirty = new Rectangle();
    private FontMetrics fm;
    private transient Image image;
    private int maxSteps = 140;
    private int progress = 0;
    private Rectangle rect = new Rectangle();
    private int size = 14;
    private String text;
    private Rectangle view;

    public SplashComponent() {
        String splashRunningTextBounds = ResourceManager.getString("SPLASH_LOAD_INFO_LOCATION");
        StringTokenizer st = new StringTokenizer(splashRunningTextBounds, " ,");
        this.view = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        String splashProgressBarBounds = ResourceManager.getString("SPLASH_PROGRESS_LOCATION");
        st = new StringTokenizer(splashProgressBarBounds, " ,");
        try {
            this.bar = new Rectangle(Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
            String splashRunningTextColor = ResourceManager.getString("SPLASH_TEXT_COLOR");
            Integer rgb = Integer.decode(splashRunningTextColor);
            this.colorText = new Color(rgb);
            String splashProgressBarColor = ResourceManager.getString("SPLASH_PROGRESS_COLOR");
            rgb = Integer.decode(splashProgressBarColor);
            this.colorBar = new Color(rgb);
            String splashProgressBarEdgeColor = ResourceManager.getString("SPLASH_PROGRESS_BORDER_COLOR");
            rgb = Integer.decode(splashProgressBarEdgeColor);
            this.colorEdge = new Color(rgb);
            String splashProgressBarCornerColor = ResourceManager.getString("SPLASH_CORNER_COLOR");
            rgb = Integer.decode(splashProgressBarCornerColor);
            this.colorCorner = new Color(rgb);
        }
        catch (NumberFormatException nfe) {
            this.colorText = Color.BLACK;
            this.colorBar = Color.ORANGE;
            this.colorEdge = Color.BLUE;
            this.colorCorner = Color.GREEN;
            this.bar = new Rectangle(0, 0, 80, 10);
        }
        try {
            String sizeStr = ResourceManager.getString("SPLASH_TEXT_SIZE");
            this.size = Integer.parseInt(sizeStr);
        }
        catch (MissingResourceException e) {
            LOGGER.error("con't find resourse:SPLASH_TEXT_SIZE");
        }
        catch (NumberFormatException nfe) {
            LOGGER.error("", (Throwable)nfe);
        }
        ImageIcon imageIcon = ResourceManager.getOEMImage("start_en.jpg");
        this.image = imageIcon.getImage();
        Font font = new Font("Dialog", 0, this.size);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(this.colorText);
        graphics.drawImage(this.image, 0, 0, null);
        Font font = new Font("Dialog", 0, 12);
        this.setFont(font);
        graphics.drawString(Framework.getInstance().getIsmVersion(), 20, 330);
        graphics.drawString(ResourceManager.getOEMString("ABOUTDIALOG_COPY_RIGHT"), 20, 380);
        if (this.maxSteps > 0) {
            graphics.setColor(this.colorBar);
            graphics.fillRect((int)this.bar.getX(), (int)this.bar.getY(), this.barStart + this.barLength, this.bar.height);
            graphics.setColor(this.colorCorner);
            graphics.drawLine((int)this.bar.getX(), (int)this.bar.getY(), (int)this.bar.getX(), (int)this.bar.getY() + this.bar.height);
            graphics.drawLine((int)this.bar.getX() + this.barStart + this.barLength, (int)this.bar.getY(), (int)this.bar.getX() + this.barStart + this.barLength, (int)this.bar.getY() + this.bar.height);
            graphics.setColor(this.colorEdge);
            graphics.drawLine((int)this.bar.getX(), (int)this.bar.getY() + this.bar.height / 2, (int)this.bar.getX(), (int)this.bar.getY() + this.bar.height / 2);
            graphics.drawLine((int)this.bar.getX() + this.barStart + this.barLength, (int)this.bar.getY() + this.bar.height / 2, (int)this.bar.getX() + this.barStart + this.barLength, (int)this.bar.getY() + this.bar.height / 2);
            this.barStart += this.barLength;
            this.barLength = 0;
        }
    }

    public void setText(String text) {
        if (null == text || !text.equals(this.text)) {
            if (null == text) {
                this.paintComponent(this.getGraphics());
            } else if (null != this.fm) {
                this.adjustText(text);
                SwingUtilities.layoutCompoundLabel(this.fm, text, null, 3, 2, 3, 2, this.view, new Rectangle(), this.rect, 0);
                this.dirty = this.dirty.union(this.rect);
                this.repaint(this.dirty);
                this.dirty = new Rectangle(this.rect);
            }
        }
    }

    @Override
    public String toString() {
        return "SplashComponent - progress: " + this.progress + '/' + this.maxSteps + " text: " + this.text;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void adjustText(String textTemp) {
        String newText = null;
        if (null == textTemp || null == this.fm) {
            return;
        }
        int width = this.fm.stringWidth(textTemp);
        if (width > this.view.width) {
            String newString;
            StringTokenizer st = new StringTokenizer(textTemp);
            String element = null;
            while (st.hasMoreTokens()) {
                element = st.nextToken();
                newString = null == newText ? element : newText + ' ' + element;
                if (this.fm.stringWidth(newString + "...") > this.view.width) {
                    this.text = newText + "...";
                    break;
                }
                newText = newString;
            }
            if (null == newText) {
                this.text = "";
                newString = "";
                newText = "";
                for (int i = 0; i < textTemp.length(); ++i) {
                    if (this.fm.stringWidth((newString = newString + textTemp.charAt(i)) + "...") > this.view.width) {
                        this.text = newText + "...";
                        break;
                    }
                    newText = newString;
                }
            }
        } else {
            this.text = textTemp;
        }
    }
}

