/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.mainframe;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.mainframe.TaskIsmBtnMousListner;
import com.huawei.ism.ui.module.task.BackgroundTask;
import com.huawei.ism.ui.module.task.BackgroundTaskListener;
import com.huawei.ism.ui.module.task.BgroudTaskRecord;
import com.huawei.ism.ui.module.task.TaskFilter;
import com.huawei.ism.ui.module.task.TaskManager;
import com.huawei.ism.ui.swing.IsmGradientPanel;
import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class StatusPanel
extends IsmGradientPanel
implements BackgroundTaskListener {
    private static JPanel taskPanel = new JPanel();
    private static JPanel timePanel = new JPanel();
    private static final long serialVersionUID = 3991131362150380840L;
    private static final int PATH_BAR_HEIGHT = 20;
    private static final Dimension STATUS_PANEL_SIZE = new Dimension(0, 26);
    private static JLabel timeLabel = new JLabel("");
    private JButton taskIsmButton;
    private JToolBar taskToolBar = new JToolBar();
    private String fcTaskImagepath = "statuspanel_fcTask.gif";
    private String frTaskImagepath = "statuspanel_frTask.gif";
    private String ncTaskImagepath = "statuspanel_ncTask.gif";
    private String nrTaskImagepath = "statuspanel_nrTask.gif";
    private String warnTaskImagepath = "statuspanel_warningTask.gif";
    private String pathMessage = "";

    public JButton getTaskIsmButton() {
        return this.taskIsmButton;
    }

    public StatusPanel() {
        JLabel userAreaSeperator = new JLabel(UIManager.getIcon("IsmStatusPane.separator"));
        this.setLayout(new BorderLayout());
        this.add((Component)timePanel, "West");
        this.add((Component)UCD.buildHBoxLeft(4, userAreaSeperator, taskPanel), "East");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TaskManager.getInstance().addBackgroundTaskListener(this);
        String timeString = dateFormat.format(new Date(System.currentTimeMillis()));
        this.setTime(timeString);
        this.setPreferredSize(STATUS_PANEL_SIZE);
        taskPanel.setLayout(new BoxLayout(taskPanel, 0));
        JLabel labTaskBar = new JLabel(ResourceManager.getString("STATUS_PANEL_TASK_LAB"));
        ImageIcon taskIcon = ResourceManager.getImage(this.ncTaskImagepath);
        this.taskIsmButton = new ToolTipButton(taskIcon);
        this.taskIsmButton.addActionListener(new TaskIsmBtnActListner());
        this.taskIsmButton.addMouseListener(new TaskIsmBtnMousListner(this));
        this.taskToolBar.setLayout(new BoxLayout(this.taskToolBar, 0));
        this.taskToolBar.add(this.taskIsmButton);
        this.taskToolBar.setFloatable(false);
        this.taskToolBar.setOpaque(false);
        this.taskToolBar.setBorder(BorderFactory.createEmptyBorder());
        taskPanel.add(labTaskBar);
        taskPanel.add(this.taskToolBar);
        taskPanel.add(Box.createRigidArea(new Dimension(8, 20)));
        timePanel.setLayout(new FlowLayout());
        ImageIcon timeIcon = ResourceManager.getImage("statusbar_time.png");
        timePanel.add(new JLabel(timeIcon));
        timePanel.add(timeLabel);
        timePanel.add(Box.createRigidArea(new Dimension(2, 20)));
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            timeLabel.setForeground(Color.WHITE);
            labTaskBar.setForeground(Color.WHITE);
        }
    }

    @Override
    public Image getBackgroudImage() {
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.blue) {
            return null;
        }
        Icon bgIcon = UIManager.getIcon("IsmStatusPane.BackgroudImage");
        if (bgIcon instanceof ImageIcon) {
            return ((ImageIcon)bgIcon).getImage();
        }
        return null;
    }

    public void setTime(String timestr) {
        timeLabel.setText(ResourceManager.getString("STATUS_PANEL_TIME") + "  " + timestr);
        this.validate();
    }

    String getTaskStatus() {
        StringBuffer tasksToolTip = new StringBuffer();
        TaskFilter filter = TaskFilter.createAllDeviceFilter();
        int successTask = 0;
        int failedTask = 0;
        int runningTask = 0;
        List<BackgroundTask> tasks = TaskManager.getInstance().getTask(filter);
        for (BackgroundTask task : tasks) {
            if (BackgroundTask.State.COMPLETED_NORMAL == task.getState() || task.getState() == BackgroundTask.State.COMPLETED_WARNING) {
                ++successTask;
                continue;
            }
            if (task.getState() == BackgroundTask.State.FAILED) {
                ++failedTask;
                continue;
            }
            if (task.getState() != BackgroundTask.State.RUNNING_NORMAL && task.getState() != BackgroundTask.State.RUNNING_WARNING) continue;
            ++runningTask;
        }
        tasksToolTip.append("<html>");
        tasksToolTip.append(ResourceManager.getString("TASK_MANAGE_SUCCESS"));
        tasksToolTip.append(successTask);
        tasksToolTip.append("<br>");
        tasksToolTip.append(ResourceManager.getString("TASK_MANAGE_FAILED"));
        tasksToolTip.append(failedTask);
        tasksToolTip.append("<br>");
        tasksToolTip.append(ResourceManager.getString("TASK_MANAGE_RUNNING"));
        tasksToolTip.append(runningTask);
        tasksToolTip.append("<html>");
        return tasksToolTip.toString();
    }

    @Override
    public void taskChanged(BgroudTaskRecord taskRecord) {
        boolean haveFaultTask = taskRecord.haveFaultTask();
        boolean haveRunningTask = taskRecord.haveRunningTask();
        boolean haveWarningTask = taskRecord.haveWarningTask();
        String path = null;
        path = haveFaultTask ? (haveRunningTask ? this.frTaskImagepath : this.fcTaskImagepath) : this.getWarnTaskPath(haveRunningTask, haveWarningTask);
        ImageIcon taskIcon = ResourceManager.getImage(path);
        this.taskIsmButton.setIcon(taskIcon);
        this.taskIsmButton.setPressedIcon(taskIcon);
        this.taskIsmButton.setRolloverIcon(taskIcon);
    }

    private String getWarnTaskPath(boolean haveRunningTask, boolean haveWarningTask) {
        String path = null;
        path = haveWarningTask ? this.warnTaskImagepath : (haveRunningTask ? this.nrTaskImagepath : this.ncTaskImagepath);
        return path;
    }

    public String getPathMessage() {
        return this.pathMessage;
    }

    static {
        taskPanel.setOpaque(false);
        timePanel.setOpaque(false);
    }

    private static class ToolTipButton
    extends ToolBarButton {
        private static final long serialVersionUID = 1L;
        private Point point = null;

        public ToolTipButton(Icon icon) {
            super(icon);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    point = null;
                }
            });
        }

        @Override
        public Point getToolTipLocation(MouseEvent event) {
            if (null == this.point) {
                int eventX = event.getX();
                int eventY = this.getY() - this.getHeight() - 45;
                this.point = new Point(eventX, eventY);
            }
            return this.point;
        }
    }

    private static final class TaskIsmBtnActListner
    implements ActionListener {
        private TaskIsmBtnActListner() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskManager.getInstance().showDialog();
        }
    }
}

