/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.graph;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public final class ImageHandler {
    private ImageHandler() {
    }

    public static ImageIcon colorImgWithRectBorder(ImageIcon imgIcon, Color borderColor) {
        Image origImage = imgIcon.getImage();
        int origImageWidth = origImage.getWidth(null);
        int origImageHeight = origImage.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(origImageWidth, origImageHeight, 6);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(origImage, 0, 0, origImageWidth, origImageHeight, null);
        graphics.setColor(borderColor);
        graphics.drawRect(0, 0, origImageWidth - 1, origImageHeight - 1);
        graphics.drawRect(1, 1, origImageWidth - 3, origImageHeight - 3);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon colorImage(ImageIcon imgIcon, Color fillColor, int alpha) {
        Image origImage = imgIcon.getImage();
        int origImageWidth = origImage.getWidth(null);
        int origImageHeight = origImage.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(origImageWidth, origImageHeight, 6);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(origImage, 0, 0, origImageWidth, origImageHeight, null);
        graphics.setColor(IsmPlafUtils.modifyAlpha(fillColor, alpha));
        graphics.fillRect(0, 0, origImageWidth, origImageHeight);
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon drawTextImage(ImageIcon imgIcon, String text, Color foreground, Point textStartPos) {
        Image origImage = imgIcon.getImage();
        int origImageWidth = origImage.getWidth(null);
        int origImageHeight = origImage.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(origImageWidth, origImageHeight, 1);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(origImage, 0, 0, origImageWidth, origImageHeight, null);
        graphics.setColor(foreground);
        graphics.drawString(text, (int)textStartPos.getX(), (int)textStartPos.getY());
        graphics.dispose();
        return new ImageIcon(bufferedImage);
    }
}

