/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.layout;

import com.huawei.ism.ui.layout.LayoutGroup;
import com.huawei.ism.util.UCD;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class LayoutUtils {
    public static JComponent doLayout(LayoutGroup group) {
        ArrayList<LayoutGroup> groups = new ArrayList<LayoutGroup>(0);
        groups.add(group);
        int minWidth = LayoutUtils.getMinWidthOfComponents(groups);
        LayoutUtils.setMinWidth(groups, minWidth);
        JComponent component = group.doLayout();
        LayoutUtils.setBorder(component, group);
        return component;
    }

    public static JComponent doVerticalLayout(List<LayoutGroup> groups) {
        int minWidth = LayoutUtils.getMinWidthOfComponents(groups);
        LayoutUtils.setMinWidth(groups, minWidth);
        Box box = Box.createVerticalBox();
        LayoutGroup layoutGroup = null;
        JComponent component = null;
        for (int i = 0; i < groups.size(); ++i) {
            layoutGroup = groups.get(i);
            component = layoutGroup.doLayout();
            LayoutUtils.setBorder(component, layoutGroup);
            box.add(component);
            if (i + 1 >= groups.size()) continue;
            box.add(Box.createVerticalStrut(8));
        }
        return box;
    }

    public static JComponent doHorizontalLayout(List<LayoutGroup> groups) {
        return LayoutUtils.doHorizontalLayout(groups, false);
    }

    public static JComponent doHorizontalLayout(List<LayoutGroup> groups, boolean alignCenter) {
        Box box = Box.createHorizontalBox();
        JComponent vBox = null;
        LayoutGroup layoutGroup = null;
        JPanel panel = null;
        int groupWidth = 0;
        for (int i = 0; i < groups.size(); ++i) {
            layoutGroup = groups.get(i);
            if (null == layoutGroup) continue;
            groupWidth = layoutGroup.getKeyMinWidth();
            layoutGroup.setKeyWidth(groupWidth);
            vBox = layoutGroup.doLayout();
            if (alignCenter) {
                LayoutUtils.setBorder(vBox, layoutGroup);
                box.add(vBox);
            } else {
                panel = UCD.layComponentToTop(vBox);
                LayoutUtils.setBorder(panel, layoutGroup);
                box.add(panel);
            }
            if (i >= groups.size() - 1) continue;
            box.add(Box.createHorizontalStrut(12));
        }
        return box;
    }

    public static int getMinWidthOfComponents(List<LayoutGroup> groups) {
        int minWidth = 0;
        int groupWidth = 0;
        for (LayoutGroup layoutGroup : groups) {
            groupWidth = layoutGroup.getKeyMinWidth();
            if (groupWidth <= minWidth) continue;
            minWidth = groupWidth;
        }
        return minWidth;
    }

    public static void setMinWidth(List<LayoutGroup> groups, int minWidth) {
        for (LayoutGroup layoutGroup : groups) {
            layoutGroup.setKeyWidth(minWidth);
        }
    }

    private static void setBorder(JComponent component, LayoutGroup layoutGroup) {
        Border border = layoutGroup.getBorder();
        if (null != border) {
            component.setBorder(border);
        }
    }
}

